/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.blobstore.reference.BlobStoreConstants;

@Singleton
public class ResourceMetadataToRelativePathResourceMetadata
implements Function<StorageMetadata, StorageMetadata> {
    @Override
    public StorageMetadata apply(StorageMetadata md) {
        Preconditions.checkNotNull(md, "metadata");
        String name = Preconditions.checkNotNull(md.getName(), "metadata.name");
        for (String suffix : BlobStoreConstants.DIRECTORY_SUFFIXES) {
            if (!name.endsWith(suffix)) continue;
            name = name.substring(0, name.length() - suffix.length());
        }
        return new StorageMetadataImpl(StorageType.RELATIVE_PATH, md.getProviderId(), name, md.getLocation(), md.getUri(), md.getETag(), md.getCreationDate(), md.getLastModified(), md.getUserMetadata());
    }
}

