/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.JustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ZoneToProvider
implements LocationsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final JustProvider justProvider;
    private final Supplier<Set<String>> zoneIdsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;

    @Inject
    ZoneToProvider(JustProvider justProvider, @Zone Supplier<Set<String>> zoneIdsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier) {
        this.justProvider = Preconditions.checkNotNull(justProvider, "justProvider");
        this.zoneIdsSupplier = Preconditions.checkNotNull(zoneIdsSupplier, "zoneIdsSupplier");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<? extends Location> get() {
        Location provider = (Location)Iterables.getOnlyElement(this.justProvider.get());
        Set<String> zoneIds = this.zoneIdsSupplier.get();
        Preconditions.checkState(!zoneIds.isEmpty(), "no zones found for provider %s, using supplier %s", (Object)provider, this.zoneIdsSupplier);
        Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
        ImmutableSet.Builder locations = ImmutableSet.builder();
        for (String zoneId : zoneIds) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(zoneId).description(zoneId).parent(provider);
            if (isoCodesById.containsKey(zoneId)) {
                builder.iso3166Codes((Iterable<String>)isoCodesById.get(zoneId).get());
            }
            locations.add(builder.build());
        }
        return locations.build();
    }
}

