/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.binders;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.net.PercentEscaper;
import org.jclouds.b2.domain.UploadUrlResponse;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;

public final class UploadFileBinder
implements MapBinder {
    private static final PercentEscaper escaper = new PercentEscaper("._-/~!$'()*;=:@", false);

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        UploadUrlResponse uploadUrl = (UploadUrlResponse)postParams.get("uploadUrl");
        String fileName = (String)postParams.get("fileName");
        String contentSha1 = (String)postParams.get("contentSha1");
        if (contentSha1 == null) {
            contentSha1 = "do_not_verify";
        }
        Map fileInfo = (Map)postParams.get("fileInfo");
        HttpRequest.Builder builder = (HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpMessage.Builder)((HttpRequest.Builder)request.toBuilder()).endpoint(uploadUrl.uploadUrl())).replaceHeader("Authorization", uploadUrl.authorizationToken())).replaceHeader("X-Bz-Content-Sha1", contentSha1)).replaceHeader("X-Bz-File-Name", escaper.escape(fileName));
        for (Map.Entry entry : fileInfo.entrySet()) {
            builder.replaceHeader("X-Bz-Info-" + (String)entry.getKey(), escaper.escape((String)entry.getValue()));
        }
        return (R)builder.build();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException();
    }
}

