/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudfiles.v1.functions;

import java.net.URI;
import java.util.ArrayList;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rackspace.cloudfiles.v1.domain.CDNContainer;
import org.jclouds.rest.InvocationContext;

public class ParseCDNContainerFromHeaders
implements Function<HttpResponse, CDNContainer>,
InvocationContext<ParseCDNContainerFromHeaders> {
    private HttpRequest request;

    @Override
    public CDNContainer apply(HttpResponse from) {
        String uri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Uri"), "X-Cdn-Uri");
        String sslUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Ssl-Uri"), "X-Cdn-Ssl-Uri");
        String streamingUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Streaming-Uri"), "X-Cdn-Streaming-Uri");
        String iosUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Ios-Uri"), "X-Cdn-Ios-Uri");
        String enabled = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Enabled"), "X-Cdn-Enabled");
        String logRetention = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Log-Retention"), "X-Log-Retention");
        String ttl = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Ttl"), "X-Ttl");
        ArrayList<String> parts = Lists.newArrayList(Splitter.on('/').split(this.request.getEndpoint().getPath()));
        Preconditions.checkArgument(!parts.isEmpty());
        return CDNContainer.builder().name((String)parts.get(parts.size() - 1)).enabled(Boolean.parseBoolean(enabled)).logRetention(Boolean.parseBoolean(logRetention)).ttl(Integer.parseInt(ttl)).uri(URI.create(uri)).sslUri(URI.create(sslUri)).streamingUri(URI.create(streamingUri)).iosUri(URI.create(iosUri)).build();
    }

    @Override
    public ParseCDNContainerFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

