/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.features;

import java.util.List;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v3.domain.Region;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/regions")
public interface RegionApi {
    @Named(value="regions:list")
    @GET
    @SelectJson(value={"regions"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Region> list();

    @Named(value="regions:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"region"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Region get(@PathParam(value="id") String var1);

    @Named(value="regions:create")
    @POST
    @SelectJson(value={"region"})
    @WrapWith(value="region")
    public Region create(@PayloadParam(value="id") String var1, @Nullable @PayloadParam(value="description") String var2, @Nullable @PayloadParam(value="parent_region_id") String var3);

    @Named(value="regions:update")
    @PATCH
    @Path(value="/{id}")
    @SelectJson(value={"region"})
    @WrapWith(value="region")
    public Region update(@PathParam(value="id") String var1, @Nullable @PayloadParam(value="description") String var2, @Nullable @PayloadParam(value="parent_region_id") String var3);

    @Named(value="regions:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

