/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.s3.Bucket;

public final class AssignCorrectHostnameForBucket
implements Function<Object, URI> {
    private final RegionToEndpointOrProviderIfNull delegate;
    private final Function<String, Optional<String>> bucketToRegion;

    @Inject
    AssignCorrectHostnameForBucket(RegionToEndpointOrProviderIfNull delegate, @Bucket Function<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
        this.delegate = delegate;
    }

    @Override
    public URI apply(Object from) {
        String bucket = from.toString();
        Optional<String> region = this.bucketToRegion.apply(bucket);
        if (region.isPresent()) {
            return this.delegate.apply(region.get());
        }
        return this.delegate.apply((Object)null);
    }
}

