/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.fallbacks;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.Fallback;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.http.HttpRequest;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.InvocationContext;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.util.S3Utils;
import org.jclouds.util.Throwables2;

public class FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists
implements Fallback<Boolean>,
InvocationContext<FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists> {
    private final S3Client client;
    private String bucket;

    @Inject
    FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists(S3Client client) {
        this.client = client;
    }

    @Override
    public Boolean createOrPropagate(Throwable t) throws Exception {
        AWSResponseException exception = Throwables2.getFirstThrowableOfType(Preconditions.checkNotNull(t, "throwable"), AWSResponseException.class);
        if (exception != null && exception.getError() != null && exception.getError().getCode() != null) {
            String code = exception.getError().getCode();
            if (code.equals("BucketAlreadyOwnedByYou")) {
                return false;
            }
            if (code.equals("OperationAborted") && this.bucket != null && this.client.bucketExists(this.bucket)) {
                return false;
            }
        }
        throw Throwables.propagate(t);
    }

    @Override
    public FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists setContext(@Nullable HttpRequest request) {
        if (request != null) {
            this.bucket = S3Utils.getBucketName(request);
        }
        return this;
    }
}

