/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Suppliers;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.RegionIdToZoneIdsSupplier;
import org.jclouds.logging.Logger;

@Singleton
public class RegionIdToZoneIdsFromConfiguration
implements RegionIdToZoneIdsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ValueOfConfigurationKeyOrNull config;
    private final String provider;
    private final Supplier<Set<String>> regionsSupplier;

    @Inject
    protected RegionIdToZoneIdsFromConfiguration(ValueOfConfigurationKeyOrNull config, @Provider String provider, @Region Supplier<Set<String>> regionsSupplier) {
        this.config = config;
        this.provider = provider;
        this.regionsSupplier = regionsSupplier;
    }

    @Override
    @Singleton
    @Zone
    public Map<String, Supplier<Set<String>>> get() {
        Set<String> regions = this.regionsSupplier.get();
        if (regions.isEmpty()) {
            this.logger.debug("no regions configured for provider %s", this.provider);
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, Supplier<ImmutableSet<String>>> regionToZones = ImmutableMap.builder();
        for (String region : regions) {
            String configKey = "jclouds.region." + region + ".zones";
            String zones = this.config.apply(configKey);
            if (zones == null) {
                this.logger.debug("config key %s not present", configKey);
                continue;
            }
            regionToZones.put(region, Suppliers.ofInstance(ImmutableSet.copyOf(Splitter.on(',').split(zones))));
        }
        return regionToZones.build();
    }
}

