/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.googlecloudstorage.domain.Bucket;

public class BucketToStorageMetadata
implements Function<Bucket, StorageMetadata> {
    private Supplier<Location> defaultLocation;

    @Inject
    BucketToStorageMetadata(Supplier<Location> defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public StorageMetadata apply(Bucket from) {
        MutableStorageMetadataImpl to = new MutableStorageMetadataImpl();
        to.setName(from.name());
        to.setLocation(this.defaultLocation.get());
        to.setType(StorageType.CONTAINER);
        return to;
    }
}

