/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.LinkedHashMultimap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimap;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;

public class AzureBlobImpl
extends PayloadEnclosingImpl
implements AzureBlob,
Comparable<AzureBlob> {
    private final MutableBlobProperties properties;
    private Multimap<String, String> allHeaders = LinkedHashMultimap.create();

    @Inject
    public AzureBlobImpl(MutableBlobProperties properties) {
        this.properties = properties;
    }

    @Override
    public MutableBlobProperties getProperties() {
        return this.properties;
    }

    @Override
    public Multimap<String, String> getAllHeaders() {
        return this.allHeaders;
    }

    @Override
    public void setAllHeaders(Multimap<String, String> allHeaders) {
        this.allHeaders = Preconditions.checkNotNull(allHeaders, "allHeaders");
    }

    @Override
    public int compareTo(AzureBlob o) {
        if (this.getProperties().getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getProperties().getName().compareTo(o.getProperties().getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AzureBlobImpl other = (AzureBlobImpl)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "[properties=" + this.properties + "]";
    }

    @Override
    public void setPayload(Payload data) {
        super.setPayload(data);
        this.properties.setContentMetadata(data.getContentMetadata());
    }
}

