/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import java.net.URI;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class RedirectionRetryHandler
implements HttpRetryHandler {
    @Inject(optional=true)
    @Named(value="jclouds.max-redirects")
    protected int retryCountLimit = 5;
    @Resource
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler backoffHandler;

    @Inject
    protected RedirectionRetryHandler(BackoffLimitedRetryHandler backoffHandler) {
        this.backoffHandler = backoffHandler;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        HttpUtils.closeClientButKeepContentStream(response);
        if (!command.isReplayable()) {
            this.logger.error("Cannot retry after redirect, command is not replayable: %s", command);
            return false;
        }
        if (command.incrementRedirectCount() > this.retryCountLimit) {
            this.logger.error("Cannot retry after redirect, command exceeded retry limit %d: %s", this.retryCountLimit, command);
            return false;
        }
        String location = response.getFirstHeaderOrNull("Location");
        if (location == null) {
            this.logger.error("Cannot retry after redirect, no host header: %s", command);
            return false;
        }
        HttpRequest current = command.getCurrentRequest();
        URI redirect = URI.create(location);
        if (!redirect.isAbsolute()) {
            if (redirect.getPath() == null) {
                this.logger.error("Cannot retry after redirect, no path in location header %s", command);
                return false;
            }
            redirect = Uris.uriBuilder(current.getEndpoint()).path(redirect.getPath()).query(redirect.getQuery()).build();
        }
        if (redirect.equals(current.getEndpoint())) {
            this.backoffHandler.imposeBackoffExponentialDelay(command.getRedirectCount(), "redirect: " + command.toString());
        } else if (current.getFirstHeaderOrNull("Host") != null && redirect.getHost() != null) {
            String host = redirect.getPort() > 0 ? redirect.getHost() + ":" + redirect.getPort() : redirect.getHost();
            command.setCurrentRequest(((HttpRequest.Builder)((HttpRequest.Builder)current.toBuilder().replaceHeader("Host", host)).endpoint(redirect)).build());
        } else {
            command.setCurrentRequest(((HttpRequest.Builder)((HttpRequest.Builder)current.toBuilder()).endpoint(redirect)).build());
        }
        return true;
    }
}

