/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jcloud.shade.com.google.inject.internal.aop;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.pulsar.jcloud.shade.com.google.inject.internal.aop.ClassDefiner;

final class HiddenClassDefiner
implements ClassDefiner {
    private static final Object THE_UNSAFE;
    private static final Object TRUSTED_LOOKUP_BASE;
    private static final Object TRUSTED_LOOKUP_OFFSET;
    private static final Method GET_OBJECT_METHOD;
    private static final Object HIDDEN_CLASS_OPTIONS;
    private static final Method HIDDEN_DEFINE_METHOD;

    HiddenClassDefiner() {
    }

    @Override
    public Class<?> define(Class<?> hostClass, byte[] bytecode) throws Exception {
        MethodHandles.Lookup trustedLookup = (MethodHandles.Lookup)GET_OBJECT_METHOD.invoke(THE_UNSAFE, TRUSTED_LOOKUP_BASE, TRUSTED_LOOKUP_OFFSET);
        MethodHandles.Lookup definedLookup = (MethodHandles.Lookup)HIDDEN_DEFINE_METHOD.invoke((Object)trustedLookup.in(hostClass), bytecode, false, HIDDEN_CLASS_OPTIONS);
        return definedLookup.lookupClass();
    }

    private static Object classOptions(String ... options) throws ClassNotFoundException {
        Class<?> optionClass = Class.forName(MethodHandles.Lookup.class.getName() + "$ClassOption");
        Object classOptions = Array.newInstance(optionClass, options.length);
        for (int i = 0; i < options.length; ++i) {
            Array.set(classOptions, i, Enum.valueOf(optionClass, options[i]));
        }
        return classOptions;
    }

    static {
        try {
            Class<?> unsafeType = Class.forName("sun.misc.Unsafe");
            Field theUnsafeField = unsafeType.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            THE_UNSAFE = theUnsafeField.get(null);
            Field trustedLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Method baseMethod = unsafeType.getMethod("staticFieldBase", Field.class);
            TRUSTED_LOOKUP_BASE = baseMethod.invoke(THE_UNSAFE, trustedLookupField);
            Method offsetMethod = unsafeType.getMethod("staticFieldOffset", Field.class);
            TRUSTED_LOOKUP_OFFSET = offsetMethod.invoke(THE_UNSAFE, trustedLookupField);
            GET_OBJECT_METHOD = unsafeType.getMethod("getObject", Object.class, Long.TYPE);
            HIDDEN_CLASS_OPTIONS = HiddenClassDefiner.classOptions("NESTMATE");
            HIDDEN_DEFINE_METHOD = MethodHandles.Lookup.class.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, HIDDEN_CLASS_OPTIONS.getClass());
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

