/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Zone;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.all.RegionToProviderOrJustProvider;
import org.jclouds.logging.Logger;

@Singleton
public class ZoneToRegionToProviderOrJustProvider
implements LocationsSupplier {
    @Resource
    protected Logger logger = Logger.NULL;
    private final RegionToProviderOrJustProvider regionToProviderOrJustProvider;
    private final Supplier<Set<String>> zoneIdsSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier;
    private final Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier;

    @Inject
    ZoneToRegionToProviderOrJustProvider(RegionToProviderOrJustProvider regionToProviderOrJustProvider, @Zone Supplier<Set<String>> zoneIdsSupplier, @Iso3166 Supplier<Map<String, Supplier<Set<String>>>> isoCodesByIdSupplier, @Zone Supplier<Map<String, Supplier<Set<String>>>> regionIdToZoneIdsSupplier) {
        this.regionToProviderOrJustProvider = Preconditions.checkNotNull(regionToProviderOrJustProvider, "regionToProviderOrJustProvider");
        this.zoneIdsSupplier = Preconditions.checkNotNull(zoneIdsSupplier, "zoneIdsSupplier");
        this.regionIdToZoneIdsSupplier = Preconditions.checkNotNull(regionIdToZoneIdsSupplier, "regionIdToZoneIdsSupplier");
        this.isoCodesByIdSupplier = Preconditions.checkNotNull(isoCodesByIdSupplier, "isoCodesByIdSupplier");
    }

    @Override
    public Set<? extends Location> get() {
        Object regionsOrJustProvider = this.regionToProviderOrJustProvider.get();
        Set<String> zoneIds = this.zoneIdsSupplier.get();
        if (zoneIds.isEmpty()) {
            return regionsOrJustProvider;
        }
        Map<String, Location> zoneIdToParent = this.setParentOfZoneToRegionOrProvider(zoneIds, (Set<? extends Location>)regionsOrJustProvider);
        Map<String, Supplier<Set<String>>> isoCodesById = this.isoCodesByIdSupplier.get();
        ImmutableSet.Builder locations = ImmutableSet.builder();
        if (!Iterables.all(regionsOrJustProvider, LocationPredicates.isProvider())) {
            locations.addAll((Iterable)regionsOrJustProvider);
        }
        for (Map.Entry<String, Location> entry : zoneIdToParent.entrySet()) {
            String zoneId = entry.getKey();
            Location parent = entry.getValue();
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(zoneId).description(zoneId).parent(parent);
            if (isoCodesById.containsKey(zoneId)) {
                builder.iso3166Codes((Iterable<String>)isoCodesById.get(zoneId).get());
            } else if (parent.getScope() == LocationScope.REGION) {
                builder.iso3166Codes(parent.getIso3166Codes());
            }
            locations.add(builder.build());
        }
        return locations.build();
    }

    private Map<String, Location> setParentOfZoneToRegionOrProvider(Set<String> zoneIds, Set<? extends Location> locations) {
        Sets.SetView<String> orphans;
        LinkedHashMap<String, Location> zoneIdToParent = Maps.newLinkedHashMap();
        Location provider = Iterables.find(locations, LocationPredicates.isProvider(), null);
        if (locations.size() == 1 && provider != null) {
            for (String zone : zoneIds) {
                zoneIdToParent.put(zone, provider);
            }
        } else {
            Map<String, Supplier<Set<String>>> regionIdToZoneIds = this.regionIdToZoneIdsSupplier.get();
            for (Location region : Iterables.filter(locations, LocationPredicates.isRegion())) {
                provider = region.getParent();
                if (regionIdToZoneIds.containsKey(region.getId())) {
                    for (String zoneId : regionIdToZoneIds.get(region.getId()).get()) {
                        if (!zoneIds.contains(zoneId)) continue;
                        zoneIdToParent.put(zoneId, region);
                    }
                    continue;
                }
                this.logger.debug("no zones configured for region: %s", region);
            }
        }
        if (!(orphans = Sets.difference(zoneIds, zoneIdToParent.keySet())).isEmpty()) {
            Preconditions.checkState(provider != null, "cannot configure zones %s as we need a parent, and the only available location [%s] is not a provider", zoneIds, locations);
            for (String orphanedZoneId : orphans) {
                zoneIdToParent.put(orphanedZoneId, provider);
            }
        }
        Preconditions.checkState(zoneIdToParent.keySet().containsAll(zoneIds), "orphaned zones: %s ", Sets.difference(zoneIds, zoneIdToParent.keySet()));
        return zoneIdToParent;
    }
}

