/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class ParseETagHeader
implements Function<HttpResponse, String> {
    @Override
    public String apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (eTag == null) {
            eTag = from.getFirstHeaderOrNull("Etag");
        }
        if (eTag != null) {
            return eTag;
        }
        throw new HttpException("did not receive ETag");
    }
}

