/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Charsets;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.location.Provider;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final Supplier<Credentials> creds;

    @Inject
    public BasicAuthentication(@Provider Supplier<Credentials> creds) {
        this.creds = Preconditions.checkNotNull(creds, "creds");
    }

    public static String basic(String user, String password) {
        return "Basic " + BaseEncoding.base64().encode(String.format("%s:%s", Preconditions.checkNotNull(user, "user"), Preconditions.checkNotNull(password, "password")).getBytes(Charsets.UTF_8));
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        Credentials currentCreds = Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", BasicAuthentication.basic(currentCreds.identity, currentCreds.credential))).build();
    }
}

