/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import java.util.Date;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSortedMap;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.Uris;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.Aws4SignerBase;

public class Aws4SignerForQueryString
extends Aws4SignerBase {
    @Inject
    public Aws4SignerForQueryString(SignatureWire signatureWire, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.aws.header.tag") String headerTag, @Provider Supplier<Credentials> creds, @TimeStamp Supplier<Date> timestampProvider, Aws4SignerBase.ServiceAndRegion serviceAndRegion, Crypto crypto) {
        super(signatureWire, headerTag, creds, timestampProvider, serviceAndRegion, crypto);
    }

    protected HttpRequest sign(HttpRequest request, long timeInSeconds) throws HttpException {
        Preconditions.checkNotNull(request, "request is not ready to sign");
        Preconditions.checkNotNull(request.getEndpoint(), "request is not ready to sign, request.endpoint not present.");
        String host = request.getEndpoint().getHost();
        Date date = (Date)this.timestampProvider.get();
        String timestamp = this.timestampFormat.format(date);
        String datestamp = this.dateFormat.format(date);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on('/').join(datestamp, region, service, "aws4_request");
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).removeHeader("x-amz-content-sha256")).removeHeader("X-Amz-Date");
        ImmutableSortedMap.Builder<String, String> signedHeadersBuilder = ImmutableSortedMap.naturalOrder();
        Uris.UriBuilder endpointBuilder = Uris.uriBuilder(request.getEndpoint());
        host = Aws4SignerForQueryString.hostHeaderFor(request.getEndpoint());
        ((ImmutableMap.Builder)signedHeadersBuilder).put("host", host);
        ImmutableMap<String, String> signedHeaders = ((ImmutableMap.Builder)signedHeadersBuilder).build();
        Credentials credentials = (Credentials)this.creds.get();
        if (credentials instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            endpointBuilder.replaceQuery("X-Amz-Security-Token", token);
        }
        endpointBuilder.replaceQuery("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        String credential = Joiner.on("/").join(credentials.identity, credentialScope, new Object[0]);
        endpointBuilder.replaceQuery("X-Amz-Credential", credential);
        endpointBuilder.replaceQuery("X-Amz-Date", timestamp);
        endpointBuilder.replaceQuery("X-Amz-Expires", String.valueOf(timeInSeconds));
        endpointBuilder.replaceQuery("X-Amz-SignedHeaders", Joiner.on(';').join(signedHeaders.keySet()));
        String stringToSign = this.createStringToSign(request.getMethod(), endpointBuilder.build(), signedHeaders, timestamp, credentialScope, this.getPayloadHash());
        this.signatureWire.getWireLog().debug("<< " + stringToSign, new Object[0]);
        byte[] signatureKey = this.signatureKey(credentials.credential, datestamp, region, service);
        String signature = BaseEncoding.base16().lowerCase().encode(this.hmacSHA256(stringToSign, signatureKey));
        endpointBuilder.replaceQuery("X-Amz-Signature", signature);
        return ((HttpRequest.Builder)requestBuilder.endpoint(endpointBuilder.build())).build();
    }

    protected String getPayloadHash() {
        return "UNSIGNED-PAYLOAD";
    }
}

