/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Optional;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicate;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.Invokable;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.Fallback;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.config.InvocationConfig;
import org.jclouds.util.Maps2;
import org.jclouds.util.Predicates2;

@Singleton
@Beta
public class ReadAnnotationsAndProperties
implements InvocationConfig {
    private final Injector injector;
    private final Fallback<Object> defaultFallback;
    private final Map<String, Long> timeouts;

    @Inject
    ReadAnnotationsAndProperties(Injector injector, Function<Predicate<String>, Map<String, String>> filterStringsBoundByName, Fallback<Object> defaultFallback) {
        this.injector = injector;
        this.defaultFallback = defaultFallback;
        this.timeouts = ReadAnnotationsAndProperties.timeouts(filterStringsBoundByName);
    }

    @Override
    public Optional<Long> getTimeoutNanos(Invocation in) {
        String commandName = this.getCommandName(in);
        Optional<Long> defaultMillis = Optional.fromNullable(this.timeouts.get("default"));
        Optional<Long> timeoutMillis = Optional.fromNullable(this.timeouts.get(commandName));
        Invokable<?, ?> invoked = in.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            timeoutMillis = timeoutMillis.or(defaultMillis);
        } else {
            String className = invoked.getOwnerType().getRawType().getSimpleName();
            timeoutMillis = timeoutMillis.or(Optional.fromNullable(this.timeouts.get(className))).or(defaultMillis);
        }
        if (timeoutMillis.isPresent()) {
            return Optional.of(TimeUnit.MILLISECONDS.toNanos(timeoutMillis.get()));
        }
        return Optional.absent();
    }

    @Override
    public String getCommandName(Invocation invocation) {
        Invokable<?, ?> invoked = invocation.getInvokable();
        if (invoked.isAnnotationPresent(Named.class)) {
            return invoked.getAnnotation(Named.class).value();
        }
        String className = invoked.getOwnerType().getRawType().getSimpleName();
        return className + "." + invoked.getName();
    }

    @Override
    public Fallback<?> getFallback(Invocation invocation) {
        org.jclouds.rest.annotations.Fallback fallback = invocation.getInvokable().getAnnotation(org.jclouds.rest.annotations.Fallback.class);
        if (fallback != null) {
            return this.injector.getInstance(fallback.value());
        }
        return this.defaultFallback;
    }

    static Map<String, Long> timeouts(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        Map<String, String> stringBoundWithTimeoutPrefix = filterStringsBoundByName.apply(Predicates2.startsWith("jclouds.timeouts."));
        Map<String, Long> longsByName = Maps.transformValues(stringBoundWithTimeoutPrefix, new Function<String, Long>(){

            @Override
            public Long apply(String input) {
                return Long.valueOf(String.valueOf(input));
            }
        });
        return Maps2.transformKeys(longsByName, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.replaceFirst(Pattern.quote("jclouds.timeouts."), "");
            }
        });
    }
}

