/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import java.io.IOException;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Strings2;

@Singleton
public class CloseContentAndSetExceptionErrorHandler
implements HttpErrorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse from) {
        try {
            String content = from.getPayload() != null ? Strings2.toStringAndClose(from.getPayload().openStream()) : null;
            command.setException(new HttpResponseException(command, from, content));
        }
        catch (IOException e) {
            command.setException(new HttpResponseException(command, from));
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }
}

