/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.predicates.validators;

import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.predicates.validators.DnsNameValidator;

@Singleton
public class ContainerNameValidator
extends DnsNameValidator {
    @Inject
    ContainerNameValidator() {
        super(3, 63);
    }

    @Override
    public void validate(String containerName) {
        super.validate(containerName);
        if (containerName.contains("--")) {
            throw this.exception(containerName, "Every dash must be followed by letter or number");
        }
        if (containerName.endsWith("-")) {
            throw this.exception(containerName, "Shouldn't end with a dash");
        }
    }

    @Override
    protected IllegalArgumentException exception(String containerName, String reason) {
        return new IllegalArgumentException(String.format("Object '%s' doesn't match Azure container naming convention. Reason: %s. For more info, please refer to http://weblogs.asp.net/vblasberg/archive/2009/02/17/azure-details-and-limitations-blobs-tables-and-queues.aspx.", containerName, reason));
    }
}

