/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import org.apache.pulsar.jcloud.shade.com.google.inject.AbstractModule;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Provider;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.AzureBlobImpl;
import org.jclouds.blobstore.config.BlobStoreObjectModule;

public class AzureBlobModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreObjectModule());
        this.bind(AzureBlob.Factory.class).to(AzureBlobFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    final AzureBlob provideAzureBlob(AzureBlob.Factory factory) {
        return factory.create(null);
    }

    @Inject
    @Provides
    final AuthType AuthTypeFromPropertyOrDefault(@Named(value="jclouds.azureblob.auth") String authType) {
        return AuthType.fromValue(authType);
    }

    private static class AzureBlobFactory
    implements AzureBlob.Factory {
        @Inject
        Provider<MutableBlobProperties> metadataProvider;

        private AzureBlobFactory() {
        }

        @Override
        public AzureBlob create(MutableBlobProperties metadata) {
            return new AzureBlobImpl(metadata != null ? metadata : this.metadataProvider.get());
        }
    }
}

