/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.predicates.validators;

import org.apache.pulsar.jcloud.shade.com.google.common.base.CharMatcher;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.predicates.Validator;

@Singleton
public class BucketNameValidator
extends Validator<String> {
    private static final CharMatcher MATCHER = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf(".-_"));

    @Inject
    public BucketNameValidator() {
    }

    @Override
    public void validate(String name) {
        if (name == null) {
            throw BucketNameValidator.exception("", "Can't be null");
        }
        if (name.length() < 3) {
            throw BucketNameValidator.exception(name, "Can't be less than 3 characters");
        }
        if (name.length() > 255) {
            throw BucketNameValidator.exception(name, "Can't be over 255 characters");
        }
        if (!MATCHER.matchesAllOf(name)) {
            throw BucketNameValidator.exception(name, "Illegal character");
        }
    }

    private static IllegalArgumentException exception(String containerName, String reason) {
        return new IllegalArgumentException(String.format("Object '%s' doesn't match S3 bucket bucket naming convention. Reason: %s. For more info, please refer to https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html", containerName, reason));
    }
}

