/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Suppliers;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.inject.Provides;
import org.apache.pulsar.jcloud.shade.com.google.inject.Scopes;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.jclouds.azure.storage.config.AzureStorageOAuthConfigFactory;
import org.jclouds.azure.storage.handlers.AzureStorageClientErrorRetryHandler;
import org.jclouds.azureblob.AzureBlobClient;
import org.jclouds.azureblob.config.AzureBlobModule;
import org.jclouds.azureblob.handlers.ParseAzureBlobErrorFromXmlContent;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class AzureBlobHttpApiModule
extends HttpApiModule<AzureBlobClient> {
    @Override
    protected void configure() {
        this.install(new AzureBlobModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(OAuthScopes.class).toInstance(OAuthScopes.NoScopes.create());
        this.bind(OAuthConfigFactory.class).to(AzureStorageOAuthConfigFactory.class).in(Scopes.SINGLETON);
        super.configure();
    }

    @Provides
    @TimeStamp
    protected final String guiceProvideTimeStamp(@TimeStamp Supplier<String> cache) {
        return this.provideTimeStamp(cache);
    }

    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return cache.get();
    }

    @Named(value="sasAuth")
    @Provides
    protected boolean authSAS(@Provider Supplier<Credentials> creds) {
        String credential = creds.get().credential;
        String formattedCredential = credential.startsWith("?") ? credential.substring(1) : credential;
        ImmutableList<String> required = ImmutableList.of("sv", "sig");
        try {
            Map<String, String> tokens = Splitter.on('&').withKeyValueSeparator('=').split(formattedCredential);
            return Iterables.all(required, Predicates.in(tokens.keySet()));
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Provides
    @TimeStamp
    protected Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration(new Supplier<String>(){

            @Override
            public String get() {
                return dateService.rfc822DateFormat();
            }
        }, seconds, TimeUnit.SECONDS);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(AzureStorageClientErrorRetryHandler.class);
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseAzureBlobErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseAzureBlobErrorFromXmlContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseAzureBlobErrorFromXmlContent.class);
    }
}

