/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.handlers;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.AtmosResponseException;
import org.jclouds.atmos.domain.AtmosError;
import org.jclouds.atmos.reference.AtmosErrorCode;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;

@Singleton
public class ParseAtmosErrorFromXmlContent
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final AtmosUtils utils;
    public static final Pattern DIRECTORY_PATH = Pattern.compile("^/rest/namespace/?([^/]+)/$");
    public static final Pattern DIRECTORY_KEY_PATH = Pattern.compile("^/rest/namespace/?([^/]+)/(.*)");

    @Inject
    public ParseAtmosErrorFromXmlContent(AtmosUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_12;
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            AtmosError error = null;
            if (response.getPayload() != null) {
                try {
                    String content = Strings2.toStringAndClose(response.getPayload().openStream());
                    if (content != null && content.indexOf(60) >= 0) {
                        error = this.utils.parseAtmosErrorFromContent(command, response, Strings2.toInputStream(content));
                    } else {
                        HttpResponseException httpResponseException2 = content != null ? new HttpResponseException(command, response, content) : httpResponseException;
                    }
                }
                catch (IOException e) {
                    this.logger.warn(e, "exception reading error from response", response);
                }
            }
            if (error != null && error.getCode() == AtmosErrorCode.RESOURCE_ALREADY_EXISTS.getCode()) {
                File file = new File(command.getCurrentRequest().getEndpoint().getPath());
                KeyAlreadyExistsException keyAlreadyExistsException = new KeyAlreadyExistsException(file.getParentFile().getAbsolutePath(), file.getName());
            } else {
                switch (response.getStatusCode()) {
                    case 401: {
                        void var3_5;
                        AuthorizationException authorizationException = new AuthorizationException(var3_5.getMessage(), (Throwable)var3_5);
                        break;
                    }
                    case 404: {
                        if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                        String message = error != null ? error.getMessage() : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
                        String path = command.getCurrentRequest().getEndpoint().getPath();
                        Matcher matcher = DIRECTORY_PATH.matcher(path);
                        if (matcher.find()) {
                            ContainerNotFoundException containerNotFoundException = new ContainerNotFoundException(matcher.group(1), message);
                            break;
                        }
                        matcher = DIRECTORY_KEY_PATH.matcher(path);
                        if (!matcher.find()) break;
                        KeyNotFoundException keyNotFoundException = new KeyNotFoundException(matcher.group(1), matcher.group(2), message);
                        break;
                    }
                    default: {
                        HttpResponseException httpResponseException3 = error != null ? new AtmosResponseException(command, response, error) : new HttpResponseException(command, response);
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload(response);
            command.setException(httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload(response);
        command.setException((Exception)var3_12);
    }
}

