/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

@Singleton
public class BlobStoreListOptionsToListOptions
implements Function<ListContainerOptions, ListOptions> {
    @Override
    public ListOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull(from, "set options to instance NONE instead of passing null");
        ListOptions httpOptions = new ListOptions();
        if (!Strings.isNullOrEmpty(from.getMarker())) {
            httpOptions.token(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.limit(from.getMaxResults());
        }
        if (from.isDetailed()) {
            httpOptions.includeMeta();
        }
        return httpOptions;
    }
}

