/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.GET;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.POST;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.Path;
import org.apache.pulsar.jcloud.shade.javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseServices;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Consumes(value={"application/json"})
@Extension(of="identity", namespace="http://docs.openstack.org/identity/api/ext/OS-KSADM/v1.0", name="OpenStack Keystone Admin", alias="OS-KSADM")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="OS-KSADM/services")
@Beta
public interface ServiceAdminApi {
    @Named(value="service:list")
    @GET
    @ResponseParser(value=ParseServices.class)
    @Transform(value=ParseServices.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Service> list();

    @Named(value="service:list")
    @GET
    @ResponseParser(value=ParseServices.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public PaginatedCollection<Service> list(PaginationOptions var1);

    @Named(value="service:create")
    @POST
    @SelectJson(value={"OS-KSADM:service"})
    @WrapWith(value="OS-KSADM:service")
    @Nullable
    public Service create(@PayloadParam(value="name") String var1, @PayloadParam(value="type") String var2, @PayloadParam(value="description") String var3);

    @Named(value="service:get")
    @GET
    @SelectJson(value={"OS-KSADM:service"})
    @Path(value="/{serviceId}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Service get(@PathParam(value="serviceId") String var1);

    @Named(value="service:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

