/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.handlers;

import java.util.ArrayList;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Joiner;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Splitter;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Lists;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azure.storage.domain.AzureStorageError;
import org.jclouds.azure.storage.handlers.ParseAzureStorageErrorFromXmlContent;
import org.jclouds.azure.storage.util.AzureStorageUtils;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ParseAzureBlobErrorFromXmlContent
extends ParseAzureStorageErrorFromXmlContent {
    @Inject
    ParseAzureBlobErrorFromXmlContent(AzureStorageUtils utils) {
        super(utils);
    }

    @Override
    protected Exception refineException(HttpCommand command, HttpResponse response, Exception exception, AzureStorageError error, String message) {
        switch (response.getStatusCode()) {
            case 404: {
                if (!command.getCurrentRequest().getMethod().equals("DELETE")) {
                    exception = new ResourceNotFoundException(message, exception);
                    ArrayList<String> parts = Lists.newArrayList(Splitter.on('/').split(command.getCurrentRequest().getEndpoint().getPath()));
                    parts.remove("");
                    if (!parts.isEmpty()) {
                        String container = (String)parts.remove(0);
                        String query = command.getCurrentRequest().getEndpoint().getQuery();
                        exception = query != null && query.indexOf("container") != -1 ? new ContainerNotFoundException(container, message) : new KeyNotFoundException(container, Joiner.on('/').join(parts), message);
                    }
                }
                return exception;
            }
        }
        return super.refineException(command, response, exception, error, message);
    }
}

