/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.s3.options.ListBucketOptions;

@Singleton
public class ContainerToBucketListOptions
implements Function<ListContainerOptions, ListBucketOptions> {
    @Override
    public ListBucketOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull(from, "set options to instance NONE instead of passing null");
        if (from.getPrefix() != null && from.getDir() != null) {
            throw new IllegalArgumentException("Cannot set both directory and prefix options");
        }
        ListBucketOptions httpOptions = new ListBucketOptions();
        if (!from.isRecursive()) {
            if (from.getDelimiter() != null) {
                httpOptions.delimiter(from.getDelimiter().toString());
            } else {
                httpOptions.delimiter("/");
            }
        }
        if (from.getDir() != null) {
            String path = from.getDir();
            if (from.getDelimiter() != null) {
                if (!path.endsWith(from.getDelimiter().toString())) {
                    path = path + from.getDelimiter();
                }
            } else if (!path.endsWith("/")) {
                path = path + "/";
            }
            httpOptions.withPrefix(path);
        }
        if (from.getPrefix() != null) {
            httpOptions.withPrefix(from.getPrefix());
        }
        if (from.getMarker() != null) {
            httpOptions.afterMarker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.maxResults(from.getMaxResults());
        }
        return httpOptions;
    }
}

