/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobMetadataToBlobProperties;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.domain.Blob;

@Singleton
public class BlobToAzureBlob
implements Function<Blob, AzureBlob> {
    private final BlobMetadataToBlobProperties blob2ObjectMd;
    private final AzureBlob.Factory objectProvider;

    @Inject
    BlobToAzureBlob(BlobMetadataToBlobProperties blob2ObjectMd, AzureBlob.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    @Override
    public AzureBlob apply(Blob from) {
        if (from == null) {
            return null;
        }
        AzureBlob object = this.objectProvider.create(this.blob2ObjectMd.apply(from.getMetadata()));
        object.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        object.setAllHeaders(from.getAllHeaders());
        return object;
    }
}

