/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.eventbus.EventBus;
import org.apache.pulsar.jcloud.shade.com.google.inject.Injector;
import org.apache.pulsar.jcloud.shade.com.google.inject.Singleton;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.rest.HttpClient;
import org.jclouds.rest.Utils;
import org.jclouds.xml.XMLParser;

@Singleton
public class UtilsImpl
implements Utils {
    private final Json json;
    private final HttpClient simpleClient;
    private final Crypto encryption;
    private final DateService date;
    private final EventBus eventBus;
    private final Map<String, Credentials> credentialStore;
    private final Logger.LoggerFactory loggerFactory;
    private Injector injector;
    private XMLParser xml;

    @Inject
    protected UtilsImpl(Injector injector, Json json, XMLParser xml, HttpClient simpleClient, Crypto encryption, DateService date, EventBus eventBus, Map<String, Credentials> credentialStore, Logger.LoggerFactory loggerFactory) {
        this.injector = injector;
        this.json = json;
        this.simpleClient = simpleClient;
        this.encryption = encryption;
        this.date = date;
        this.eventBus = eventBus;
        this.credentialStore = credentialStore;
        this.loggerFactory = loggerFactory;
        this.xml = xml;
    }

    @Override
    public DateService date() {
        return this.date;
    }

    @Override
    public Crypto crypto() {
        return this.encryption;
    }

    @Override
    public HttpClient http() {
        return this.simpleClient;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public Logger.LoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Json json() {
        return this.json;
    }

    @Override
    @Beta
    public Injector injector() {
        return this.injector;
    }

    @Override
    public XMLParser xml() {
        return this.xml;
    }

    @Override
    public Map<String, Credentials> credentialStore() {
        return this.credentialStore;
    }
}

