/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Suppliers;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.inject.assistedinject.Assisted;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

public class LocationIdToURIFromConfigurationOrDefaultToProvider
implements Supplier<Map<String, Supplier<URI>>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ValueOfConfigurationKeyOrNull config;
    protected final Supplier<Set<String>> locationIds;
    protected final Supplier<URI> providerURI;
    protected final String configPrefix;

    @Inject
    public LocationIdToURIFromConfigurationOrDefaultToProvider(ValueOfConfigurationKeyOrNull config, @Provider Supplier<URI> providerURI, @Assisted Supplier<Set<String>> locationIds, @Assisted String configPrefix) {
        this.config = config;
        this.locationIds = locationIds;
        this.providerURI = providerURI;
        this.configPrefix = configPrefix;
    }

    @Override
    public Map<String, Supplier<URI>> get() {
        ImmutableMap.Builder<String, Supplier<URI>> locations = ImmutableMap.builder();
        for (String location : this.locationIds.get()) {
            String configKey = this.configPrefix + "." + location + "." + "endpoint";
            String locationUri = this.config.apply(configKey);
            if (locationUri == null) {
                this.logger.debug("config key %s not present, defaulting to %s", configKey, this.providerURI);
                locations.put(location, this.providerURI);
                continue;
            }
            locations.put(location, Suppliers.ofInstance(URI.create(locationUri)));
        }
        return locations.build();
    }
}

