/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserMetadataToHeadersWithPrefix
implements Binder {
    private final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindUserMetadataToHeadersWithPrefix(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = Preconditions.checkNotNull(metadataPrefixer, "metadataPrefixer");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof Blob, "this binder is only valid for Blobs!");
        Preconditions.checkNotNull(request, "request");
        return this.metadataPrefixer.bindToRequest(request, ((Blob)Blob.class.cast(input)).getMetadata().getUserMetadata());
    }
}

