/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.filters;

import java.util.TreeSet;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Multimaps;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Sets;
import org.apache.pulsar.jcloud.shade.com.google.common.io.BaseEncoding;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteProcessor;
import org.apache.pulsar.jcloud.shade.com.google.common.io.ByteStreams;
import org.apache.pulsar.jcloud.shade.javax.annotation.Resource;
import org.apache.pulsar.jcloud.shade.javax.inject.Inject;
import org.apache.pulsar.jcloud.shade.javax.inject.Named;
import org.apache.pulsar.jcloud.shade.javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SignRequest
implements HttpRequestFilter {
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    Logger logger = Logger.NULL;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SignRequest(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, @TimeStamp org.apache.pulsar.jcloud.shade.javax.inject.Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.signatureWire = signatureWire;
        this.creds = creds;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.put("x-emc-uid", this.creds.get().identity);
        String date = this.timeStampProvider.get();
        builder.put("Date", date);
        if (request.getHeaders().containsKey("x-emc-date")) {
            builder.put("x-emc-date", date);
        }
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(builder.build()))).build();
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-emc-signature", signature)).build();
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    public String calculateSignature(String toSign) {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        try {
            ByteProcessor<byte[]> hmacSHA1 = Macs.asByteProcessor(this.crypto.hmacSHA1(BaseEncoding.base64().decode(this.creds.get().credential)));
            return BaseEncoding.base64().encode(ByteStreams.readBytes(Strings2.toInputStream(toSign), hmacSHA1));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeSet<String> headers = Sets.newTreeSet(request.getHeaders().keySet());
        for (String header : headers) {
            if (!header.startsWith("x-emc-") || header.equals("x-emc-signature")) continue;
            toSign.append(header.toLowerCase()).append(":");
            for (String value : request.getHeaders().get(header)) {
                value = value.replace("  ", " ");
                value = Patterns.NEWLINE_PATTERN.matcher(value).replaceAll("");
                toSign.append(value).append(' ');
            }
            toSign.deleteCharAt(toSign.lastIndexOf(" "));
            toSign.append("\n");
        }
        if (toSign.charAt(toSign.length() - 1) == '\n') {
            toSign.deleteCharAt(toSign.length() - 1);
        }
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    @VisibleForTesting
    void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        toSign.append(HttpUtils.nullToEmpty(request.getHeaders().get("Range")).toLowerCase()).append("\n");
        toSign.append(request.getFirstHeaderOrNull("Date")).append("\n");
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath().toLowerCase());
        String query = request.getEndpoint().getRawQuery();
        if (query != null) {
            toSign.append("?").append(query);
        }
        toSign.append("\n");
    }
}

