/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.distributedlog.common.config.ConcurrentBaseConfiguration;
import org.apache.distributedlog.common.config.ConcurrentConstConfiguration;
import org.apache.distributedlog.common.config.ConfigurationListener;
import org.apache.distributedlog.common.config.ConfigurationSubscription;
import org.apache.distributedlog.common.config.FileConfigurationBuilder;
import org.apache.distributedlog.common.config.PropertiesConfigurationBuilder;
import org.apache.distributedlog.common.config.PropertiesWriter;
import org.jmock.lib.concurrent.DeterministicScheduler;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfigurationSubscription {
    static final Logger LOG = LoggerFactory.getLogger(TestConfigurationSubscription.class);

    private void ensureConfigReloaded() throws InterruptedException {
        Thread.sleep(1L);
    }

    @Test(timeout=60000L)
    public void testReloadConfiguration() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        PropertiesConfigurationBuilder builder = new PropertiesConfigurationBuilder(writer.getFile().toURI().toURL());
        ConcurrentConstConfiguration conf = new ConcurrentConstConfiguration((Configuration)new CompositeConfiguration());
        DeterministicScheduler executorService = new DeterministicScheduler();
        ArrayList fileConfigBuilders = Lists.newArrayList((Object[])new FileConfigurationBuilder[]{builder});
        ConfigurationSubscription confSub = new ConfigurationSubscription((ConcurrentBaseConfiguration)conf, (List)fileConfigBuilders, (ScheduledExecutorService)executorService, 100, TimeUnit.MILLISECONDS);
        final AtomicReference confHolder = new AtomicReference();
        confSub.registerListener(new ConfigurationListener(){

            public void onReload(ConcurrentBaseConfiguration conf) {
                confHolder.set(conf);
            }
        });
        Assert.assertEquals(null, (Object)conf.getProperty("prop1"));
        writer.setProperty("prop1", "1");
        writer.save();
        this.ensureConfigReloaded();
        confSub.reload();
        Assert.assertNotNull(confHolder.get());
        Assert.assertTrue((conf == confHolder.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1", (Object)conf.getProperty("prop1"));
    }

    @Test(timeout=60000L)
    public void testAddReloadBasicsConfig() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        DeterministicScheduler mockScheduler = new DeterministicScheduler();
        PropertiesConfigurationBuilder builder = new PropertiesConfigurationBuilder(writer.getFile().toURI().toURL());
        ConcurrentConstConfiguration conf = new ConcurrentConstConfiguration((Configuration)new CompositeConfiguration());
        ArrayList fileConfigBuilders = Lists.newArrayList((Object[])new FileConfigurationBuilder[]{builder});
        ConfigurationSubscription confSub = new ConfigurationSubscription((ConcurrentBaseConfiguration)conf, (List)fileConfigBuilders, (ScheduledExecutorService)mockScheduler, 100, TimeUnit.MILLISECONDS);
        Assert.assertEquals(null, (Object)conf.getProperty("prop1"));
        writer.setProperty("prop1", "1");
        writer.save();
        this.ensureConfigReloaded();
        mockScheduler.tick(100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"1", (Object)conf.getProperty("prop1"));
    }

    @Test(timeout=60000L)
    public void testInitialConfigLoad() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        writer.setProperty("prop1", "1");
        writer.setProperty("prop2", "abc");
        writer.setProperty("prop3", "123.0");
        writer.setProperty("prop4", "11132");
        writer.setProperty("prop5", "true");
        writer.save();
        DeterministicScheduler mockScheduler = new DeterministicScheduler();
        PropertiesConfigurationBuilder builder = new PropertiesConfigurationBuilder(writer.getFile().toURI().toURL());
        ConcurrentConstConfiguration conf = new ConcurrentConstConfiguration((Configuration)new CompositeConfiguration());
        ArrayList fileConfigBuilders = Lists.newArrayList((Object[])new FileConfigurationBuilder[]{builder});
        ConfigurationSubscription confSub = new ConfigurationSubscription((ConcurrentBaseConfiguration)conf, (List)fileConfigBuilders, (ScheduledExecutorService)mockScheduler, 100, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)conf.getInt("prop1"));
        Assert.assertEquals((Object)"abc", (Object)conf.getString("prop2"));
        Assert.assertEquals((double)123.0, (double)conf.getFloat("prop3"), (double)0.0);
        Assert.assertEquals((long)11132L, (long)conf.getInt("prop4"));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("prop5"));
    }

    @Test(timeout=60000L)
    public void testExceptionInConfigLoad() throws Exception {
        PropertiesWriter writer = new PropertiesWriter();
        writer.setProperty("prop1", "1");
        writer.save();
        DeterministicScheduler mockScheduler = new DeterministicScheduler();
        PropertiesConfigurationBuilder builder = new PropertiesConfigurationBuilder(writer.getFile().toURI().toURL());
        ConcurrentConstConfiguration conf = new ConcurrentConstConfiguration((Configuration)new CompositeConfiguration());
        ArrayList fileConfigBuilders = Lists.newArrayList((Object[])new FileConfigurationBuilder[]{builder});
        ConfigurationSubscription confSub = new ConfigurationSubscription((ConcurrentBaseConfiguration)conf, (List)fileConfigBuilders, (ScheduledExecutorService)mockScheduler, 100, TimeUnit.MILLISECONDS);
        final AtomicInteger count = new AtomicInteger(1);
        conf.addConfigurationListener(new org.apache.commons.configuration.event.ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                LOG.info("config changed {}", (Object)event);
                if (!event.isBeforeUpdate()) {
                    count.getAndIncrement();
                    throw new RuntimeException("config listener threw and exception");
                }
            }
        });
        int i = 0;
        int initial = 0;
        while (count.get() == initial) {
            writer.setProperty("prop1", Integer.toString(i++));
            writer.save();
            mockScheduler.tick(100L, TimeUnit.MILLISECONDS);
        }
        initial = count.get();
        while (count.get() == initial) {
            writer.setProperty("prop1", Integer.toString(i++));
            writer.save();
            mockScheduler.tick(100L, TimeUnit.MILLISECONDS);
        }
    }
}

