/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.common.config;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesWriter {
    static final Logger LOG = LoggerFactory.getLogger(PropertiesWriter.class);
    final FileOutputStream outputStream;
    final File configFile;
    final Properties properties;

    public PropertiesWriter() throws Exception {
        this(null);
    }

    public PropertiesWriter(File configFile) throws Exception {
        this.configFile = null == configFile ? File.createTempFile("temp", ".conf") : configFile;
        this.configFile.deleteOnExit();
        this.properties = new Properties();
        this.outputStream = new FileOutputStream(this.configFile);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public void save() throws Exception {
        FileOutputStream outputStream = new FileOutputStream(this.configFile);
        this.properties.store(outputStream, null);
        this.configFile.setLastModified(this.configFile.lastModified() + 1000L);
        LOG.debug("save modified={}", (Object)this.configFile.lastModified());
    }

    public File getFile() {
        return this.configFile;
    }
}

