/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.shade.org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.pulsar.PerTopicOffset;
import org.apache.spark.sql.pulsar.PulsarHelper;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset$;
import org.apache.spark.sql.pulsar.UserProvidedMessageId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A\u0001C\u0005\u0001)!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015I\u0004\u0001\"\u0011;\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015A\u0007\u0001\"\u0003j\u0005}\u0001V\u000f\\:beN{WO]2f\u0013:LG/[1m\u001f\u001a47/\u001a;Xe&$XM\u001d\u0006\u0003\u0015-\ta\u0001];mg\u0006\u0014(B\u0001\u0007\u000e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011C\u0001\u0001\u0016!\r12$H\u0007\u0002/)\u0011\u0001$G\u0001\ngR\u0014X-Y7j]\u001eT!AG\u0006\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001\u000f\u0018\u0005=AEIR*NKR\fG-\u0019;b\u0019><\u0007C\u0001\u0010 \u001b\u0005I\u0011B\u0001\u0011\n\u0005Q\u0019\u0006/Z2jM&\u001c\u0007+\u001e7tCJ|eMZ:fi\u0006a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\u0017%\u0011Qe\u0003\u0002\r'B\f'o[*fgNLwN\\\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\t\u0003QEr!!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0002\u001fs_>$hHC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001T&\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019.\u0003\u0019a\u0014N\\5u}Q\u0019ag\u000e\u001d\u0011\u0005y\u0001\u0001\"B\u0011\u0004\u0001\u0004\u0011\u0003\"\u0002\u0014\u0004\u0001\u00049\u0013!C:fe&\fG.\u001b>f)\rYt(\u0011\t\u0003yuj\u0011!L\u0005\u0003}5\u0012A!\u00168ji\")\u0001\t\u0002a\u0001;\u0005AQ.\u001a;bI\u0006$\u0018\rC\u0003C\t\u0001\u00071)A\u0002pkR\u0004\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u0005%|'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0002Z3tKJL\u0017\r\\5{KR\u0011Q$\u0014\u0005\u0006\u001d\u0016\u0001\raT\u0001\u0003S:\u0004\"\u0001\u0012)\n\u0005E+%aC%oaV$8\u000b\u001e:fC6\f\u0001cZ3u\u0013:LG/[1m\u001f\u001a47/\u001a;\u0015\u000bu!\u0016LX2\t\u000bU3\u0001\u0019\u0001,\u0002\u0019A,Hn]1s\u0011\u0016d\u0007/\u001a:\u0011\u0005y9\u0016B\u0001-\n\u00051\u0001V\u000f\\:be\"+G\u000e]3s\u0011\u0015Qf\u00011\u0001\\\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bC\u0001\u0010]\u0013\ti\u0016B\u0001\bQKJ$v\u000e]5d\u001f\u001a47/\u001a;\t\u000b}3\u0001\u0019\u00011\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t!\ta\u0014-\u0003\u0002c[\t\u0019\u0011J\u001c;\t\u000b\u00114\u0001\u0019A3\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB!AHZ\u0014<\u0013\t9WFA\u0005Gk:\u001cG/[8oc\u00051R.\u0019:l\u001f\u001a47/\u001a;Vg\u0016\u0014\bK]8wS\u0012,G\r\u0006\u0002\u001eU\")1n\u0002a\u0001;\u00059qN\u001a4tKR\u001c\b")
public class PulsarSourceInitialOffsetWriter
extends HDFSMetadataLog<SpecificPulsarOffset> {
    public void serialize(SpecificPulsarOffset metadata, OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringBuilder(2).append("v").append(PulsarSourceUtils$.MODULE$.VERSION()).append("\n").toString());
        writer.write(metadata.json());
        writer.flush();
    }

    public SpecificPulsarOffset deserialize(InputStream in) {
        String content = IOUtils.toString(new InputStreamReader(in, StandardCharsets.UTF_8));
        Predef$.MODULE$.assert(content.length() != 0);
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
            int indexOfNewLine = content.indexOf("\n");
            if (indexOfNewLine > 0) {
                int version = this.validateVersion(content.substring(0, indexOfNewLine), PulsarSourceUtils$.MODULE$.VERSION());
                return SpecificPulsarOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            }
            throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
        }
        throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
    }

    public SpecificPulsarOffset getInitialOffset(PulsarHelper pulsarHelper, PerTopicOffset startingOffsets, int pollTimeoutMs, Function1<String, BoxedUnit> reportDataLoss) {
        Option deserializedOffset = this.get(0L).map((Function1 & Serializable & scala.Serializable)x$2 -> this.markOffsetUserProvided((SpecificPulsarOffset)x$2));
        return (SpecificPulsarOffset)deserializedOffset.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            SpecificPulsarOffset actualOffsets = new SpecificPulsarOffset(pulsarHelper.actualOffsets(startingOffsets, pollTimeoutMs, reportDataLoss));
            this.add(0L, actualOffsets);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Initial Offsets: ").append(actualOffsets).toString());
            return actualOffsets;
        });
    }

    private SpecificPulsarOffset markOffsetUserProvided(SpecificPulsarOffset offsets) {
        Map wrappedOffsets = (Map)offsets.topicOffsets().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            block2: {
                MessageId mid;
                String tp;
                block4: {
                    block3: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        tp = (String)tuple2._1();
                        mid = (MessageId)tuple2._2();
                        if (mid instanceof UserProvidedMessageId) break block3;
                        MessageId messageId = mid;
                        MessageId messageId2 = MessageId.earliest;
                        if (messageId != null ? !messageId.equals(messageId2) : messageId2 != null) break block4;
                    }
                    return new Tuple2((Object)tp, (Object)mid);
                }
                return new Tuple2((Object)tp, (Object)new UserProvidedMessageId(mid));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        return new SpecificPulsarOffset((Map<String, MessageId>)wrappedOffsets);
    }

    public PulsarSourceInitialOffsetWriter(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(SpecificPulsarOffset.class));
    }
}

