/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.util.Optional;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReportsSourceMetrics;
import org.apache.spark.sql.connector.read.streaming.SupportsAdmissionControl;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.pulsar.PerTopicOffset;
import org.apache.spark.sql.pulsar.PulsarClientFactory$;
import org.apache.spark.sql.pulsar.PulsarHelper;
import org.apache.spark.sql.pulsar.PulsarOffsetRange;
import org.apache.spark.sql.pulsar.PulsarOffsetRange$;
import org.apache.spark.sql.pulsar.PulsarSourceInitialOffsetWriter;
import org.apache.spark.sql.pulsar.PulsarSourceRDD;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.ReadMaxBytes;
import org.apache.spark.sql.pulsar.SchemaInfoSerializable;
import org.apache.spark.sql.pulsar.SchemaUtils$;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMb!B\u0012%\u0001\u0011r\u0003\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011]\u0003!\u0011!Q\u0001\naC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\ta\u0002\u0011\t\u0011)A\u0005;\"A\u0011\u000f\u0001B\u0001B\u0003%1\r\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003t\u0011!1\bA!A!\u0002\u00139\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u0013}\u0004!\u0011!Q\u0001\n\u0005\u0005\u0001\"CA\u0004\u0001\t\u0005\t\u0015!\u0003d\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001e\u0011%\t)\u0005\u0001b\u0001\n\u0003\t9\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA%\u0011%\t9\u0006\u0001a\u0001\n\u0013\tI\u0006C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0003\u0002^!A\u00111\r\u0001!B\u0013\t\t\u0001\u0003\u0006\u0002f\u0001A)\u0019!C\u0005\u0003OB\u0011\"a\u001c\u0001\u0001\u0004%I!!\u001d\t\u0013\u0005=\u0005\u00011A\u0005\n\u0005E\u0005\u0002CAK\u0001\u0001\u0006K!a\u001d\t\u0013\u0005]\u0005A1A\u0005\n\u0005e\u0005\u0002CAS\u0001\u0001\u0006I!a'\t\u0015\u0005\u001d\u0006\u0001#b\u0001\n\u0013\tI\u000bC\u0004\u00022\u0002!\t%a/\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007bBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\u0011I\u0002\u0001C!\u00057AqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u00030\u0001!\tE!\r\u0003\u0019A+Hn]1s'>,(oY3\u000b\u0005\u00152\u0013A\u00029vYN\f'O\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005%R\u0013!B:qCJ\\'BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001e\u001cb\u0001A\u00188\u007f\u0015s\u0005C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011a\u0017M\\4\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014!C:ue\u0016\fW.\u001b8h\u0015\tad%A\u0005fq\u0016\u001cW\u000f^5p]&\u0011a(\u000f\u0002\u0007'>,(oY3\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tC\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0011\u000b%a\u0002'pO\u001eLgn\u001a\t\u0003\r2k\u0011a\u0012\u0006\u0003u!S!!\u0013&\u0002\tI,\u0017\r\u001a\u0006\u0003\u0017\u001a\n\u0011bY8o]\u0016\u001cGo\u001c:\n\u00055;%\u0001G*vaB|'\u000f^:BI6L7o]5p]\u000e{g\u000e\u001e:pYB\u0011aiT\u0005\u0003!\u001e\u0013ACU3q_J$8oU8ve\u000e,W*\u001a;sS\u000e\u001c\u0018AC:rY\u000e{g\u000e^3yi\u000e\u0001\u0001C\u0001+V\u001b\u00051\u0013B\u0001,'\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\raVd7/\u0019:IK2\u0004XM\u001d\t\u00033jk\u0011\u0001J\u0005\u00037\u0012\u0012A\u0002U;mg\u0006\u0014\b*\u001a7qKJ\f!b\u00197jK:$8i\u001c8g!\u0011q\u0016mY\u0018\u000e\u0003}S!\u0001Y\u001a\u0002\tU$\u0018\u000e\\\u0005\u0003E~\u00131!T1q!\t!WN\u0004\u0002fWB\u0011a-[\u0007\u0002O*\u0011\u0001NU\u0001\u0007yI|w\u000e\u001e \u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Y&\f!B]3bI\u0016\u00148i\u001c8g\u00031iW\r^1eCR\f\u0007+\u0019;i\u0003=\u0019H/\u0019:uS:<wJ\u001a4tKR\u001c\bCA-u\u0013\t)HE\u0001\bQKJ$v\u000e]5d\u001f\u001a47/\u001a;\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t!\tA\u00180D\u0001j\u0013\tQ\u0018NA\u0002J]R\f!#\\1y\u0005f$Xm\u001d)feR\u0013\u0018nZ4feB\u0011\u00010`\u0005\u0003}&\u0014A\u0001T8oO\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bc\u0001=\u0002\u0004%\u0019\u0011QA5\u0003\u000f\t{w\u000e\\3b]\u000612/\u001e2tGJL\u0007\u000f^5p]:\u000bW.\u001a)sK\u001aL\u00070A\u0006kg>tw\n\u001d;j_:\u001c\b\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005UN|gNC\u0002\u0002\u0016\u0019\n\u0001bY1uC2L8\u000f^\u0005\u0005\u00033\tyAA\tK'>su\n\u001d;j_:\u001c\u0018J\u001c*fC\u0012\fa\u0001P5oSRtD\u0003GA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026A\u0011\u0011\f\u0001\u0005\u0006#2\u0001\ra\u0015\u0005\u0006/2\u0001\r\u0001\u0017\u0005\u000692\u0001\r!\u0018\u0005\u0006a2\u0001\r!\u0018\u0005\u0006c2\u0001\ra\u0019\u0005\u0006e2\u0001\ra\u001d\u0005\u0006m2\u0001\ra\u001e\u0005\u0006w2\u0001\r\u0001 \u0005\u0007\u007f2\u0001\r!!\u0001\t\r\u0005\u001dA\u00021\u0001d\u0011\u001d\tI\u0001\u0004a\u0001\u0003\u0017\t!a]2\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u007fi\u0011\u0001K\u0005\u0004\u0003\u0003B#\u0001D*qCJ\\7i\u001c8uKb$\u0018aA:dA\u0005q!/\u001a9peR$\u0015\r^1M_N\u001cXCAA%!\u0019A\u00181J2\u0002P%\u0019\u0011QJ5\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001=\u0002R%\u0019\u00111K5\u0003\tUs\u0017\u000e^\u0001\u0010e\u0016\u0004xN\u001d;ECR\fGj\\:tA\u000591\u000f^8qa\u0016$WCAA\u0001\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\t\u0005=\u0013q\f\u0005\n\u0003C\u0012\u0012\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00132\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0013aE5oSRL\u0017\r\u001c+pa&\u001cwJ\u001a4tKR\u001cXCAA5!\rI\u00161N\u0005\u0004\u0003[\"#\u0001F*qK\u000eLg-[2Qk2\u001c\u0018M](gMN,G/A\ndkJ\u0014XM\u001c;U_BL7m\u00144gg\u0016$8/\u0006\u0002\u0002tA)\u00010!\u001e\u0002z%\u0019\u0011qO5\u0003\r=\u0003H/[8o!\u0019!\u00171P2\u0002~%\u0011!m\u001c\t\u0005\u0003\u007f\nY)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u000f\u000bI)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003K)JA!!$\u0002\u0002\nIQ*Z:tC\u001e,\u0017\nZ\u0001\u0018GV\u0014(/\u001a8u)>\u0004\u0018nY(gMN,Go]0%KF$B!a\u0014\u0002\u0014\"I\u0011\u0011\r\f\u0002\u0002\u0003\u0007\u00111O\u0001\u0015GV\u0014(/\u001a8u)>\u0004\u0018nY(gMN,Go\u001d\u0011\u0002)I|wo\u001d\"zi\u0016\u001c\u0018iY2v[Vd\u0017\r^8s+\t\tY\n\u0005\u0003\u0002\u001e\u0006\u0005VBAAP\u0015\t\u0001\u0007&\u0003\u0003\u0002$\u0006}%a\u0004'p]\u001e\f5mY;nk2\fGo\u001c:\u0002+I|wo\u001d\"zi\u0016\u001c\u0018iY2v[Vd\u0017\r^8sA\u0005a\u0001/\u001e7tCJ\u001c6\r[3nCV\u0011\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0019\u00198\r[3nC*!\u0011QWAE\u0003\u0019\u0019w.\\7p]&!\u0011\u0011XAX\u0005)\u00196\r[3nC&sgm\u001c\u000b\u0003\u0003{\u0003B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u00074\u0013!\u0002;za\u0016\u001c\u0018\u0002BAd\u0003\u0003\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003%9W\r^(gMN,G/\u0006\u0002\u0002NB)\u00010!\u001e\u0002PB\u0019\u0001(!5\n\u0007\u0005M\u0017H\u0001\u0004PM\u001a\u001cX\r^\u0001\rY\u0006$Xm\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u00033\fi.!9\u0011\u0007\u0019\u000bY.C\u0002\u0002T\u001eCq!a8\u001e\u0001\u0004\tI.\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u000f\u0005\rX\u00041\u0001\u0002f\u0006I!/Z1e\u0019&l\u0017\u000e\u001e\t\u0004\r\u0006\u001d\u0018bAAu\u000f\nI!+Z1e\u0019&l\u0017\u000e^\u0001\u0014O\u0016$H)\u001a4bk2$(+Z1e\u0019&l\u0017\u000e\u001e\u000b\u0003\u0003K\f\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0003g\u0014\tB!\u0006\u0011\t\u0005U(1\u0002\b\u0005\u0003o\u00149A\u0004\u0003\u0002z\n\u0015a\u0002BA~\u0005\u0007qA!!@\u0003\u00029\u0019a-a@\n\u00035J!a\u000b\u0017\n\u0005%R\u0013BA\u0014)\u0013\r\u0011IAJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iAa\u0004\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u0001B\u0005M!9!1C\u0010A\u0002\u00055\u0017!B:uCJ$\bb\u0002B\f?\u0001\u0007\u0011qZ\u0001\u0004K:$\u0017AB2p[6LG\u000f\u0006\u0003\u0002P\tu\u0001b\u0002B\fA\u0001\u0007\u0011qZ\u0001\b[\u0016$(/[2t)\u0011\u0011\u0019C!\n\u0011\ty\u000b7m\u0019\u0005\b\u0005O\t\u0003\u0019\u0001B\u0015\u0003!y\u0007\u000f^5p]\u0006d\u0007#\u00020\u0003,\u0005e\u0017b\u0001B\u0017?\nAq\n\u001d;j_:\fG.\u0001\u0003ti>\u0004HCAA(\u0001")
public class PulsarSource
implements Source,
Logging,
SupportsAdmissionControl,
ReportsSourceMetrics {
    private SpecificPulsarOffset initialTopicOffsets;
    private SchemaInfo pulsarSchema;
    private final SQLContext sqlContext;
    private final PulsarHelper pulsarHelper;
    private final java.util.Map<String, Object> clientConf;
    private final java.util.Map<String, Object> readerConf;
    private final String metadataPath;
    private PerTopicOffset startingOffsets;
    private final int pollTimeoutMs;
    private final long maxBytesPerTrigger;
    private final boolean failOnDataLoss;
    private final String subscriptionNamePrefix;
    private final JSONOptionsInRead jsonOptions;
    private final SparkContext sc;
    private final Function1<String, BoxedUnit> reportDataLoss;
    private boolean stopped;
    private Option<scala.collection.immutable.Map<String, MessageId>> currentTopicOffsets;
    private final LongAccumulator rowsBytesAccumulator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public Offset reportLatestOffset() {
        return super.reportLatestOffset();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Offset initialOffset() {
        return Source.initialOffset$((Source)this);
    }

    public Offset deserializeOffset(String json) {
        return Source.deserializeOffset$((Source)this, (String)json);
    }

    public void commit(Offset end) {
        Source.commit$((Source)this, (Offset)end);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    public Function1<String, BoxedUnit> reportDataLoss() {
        return this.reportDataLoss;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private SpecificPulsarOffset initialTopicOffsets$lzycompute() {
        PulsarSource pulsarSource = this;
        synchronized (pulsarSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                PulsarSourceInitialOffsetWriter metadataLog = new PulsarSourceInitialOffsetWriter(this.sqlContext.sparkSession(), this.metadataPath);
                this.initialTopicOffsets = metadataLog.getInitialOffset(this.pulsarHelper, this.startingOffsets, this.pollTimeoutMs, this.reportDataLoss());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.startingOffsets = null;
        return this.initialTopicOffsets;
    }

    private SpecificPulsarOffset initialTopicOffsets() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.initialTopicOffsets$lzycompute();
        }
        return this.initialTopicOffsets;
    }

    private Option<scala.collection.immutable.Map<String, MessageId>> currentTopicOffsets() {
        return this.currentTopicOffsets;
    }

    private void currentTopicOffsets_$eq(Option<scala.collection.immutable.Map<String, MessageId>> x$1) {
        this.currentTopicOffsets = x$1;
    }

    private LongAccumulator rowsBytesAccumulator() {
        return this.rowsBytesAccumulator;
    }

    private SchemaInfo pulsarSchema$lzycompute() {
        PulsarSource pulsarSource = this;
        synchronized (pulsarSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.pulsarSchema = this.pulsarHelper.getPulsarSchema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pulsarSchema;
    }

    private SchemaInfo pulsarSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.pulsarSchema$lzycompute();
        }
        return this.pulsarSchema;
    }

    public StructType schema() {
        return SchemaUtils$.MODULE$.pulsarSourceSchema(this.pulsarSchema());
    }

    public Option<org.apache.spark.sql.execution.streaming.Offset> getOffset() {
        throw new UnsupportedOperationException("latestOffset(Offset, ReadLimit) should be called instead of this method");
    }

    public Offset latestOffset(Offset startingOffset, ReadLimit readLimit) {
        this.initialTopicOffsets();
        ReadLimit readLimit2 = readLimit;
        if (readLimit2 instanceof ReadMaxBytes) {
            ReadMaxBytes readMaxBytes = (ReadMaxBytes)readLimit2;
            long maxBytes = readMaxBytes.maxBytes();
            Offset offset = startingOffset;
            if (offset == null) {
                return this.pulsarHelper.latestOffsets((Offset)this.initialTopicOffsets(), maxBytes);
            }
            return this.pulsarHelper.latestOffsets(offset, maxBytes);
        }
        if (readLimit2 instanceof ReadAllAvailable) {
            return this.pulsarHelper.fetchLatestOffsets();
        }
        throw new MatchError((Object)readLimit2);
    }

    public ReadLimit getDefaultReadLimit() {
        if (this.maxBytesPerTrigger == 0L) {
            return ReadLimit.allAvailable();
        }
        return new ReadMaxBytes(this.maxBytesPerTrigger);
    }

    public Dataset<Row> getBatch(Option<org.apache.spark.sql.execution.streaming.Offset> start, org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<String, MessageId> map;
        Option<org.apache.spark.sql.execution.streaming.Offset> option;
        this.initialTopicOffsets();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("getBatch called with start = ").append(start).append(", end = ").append(end).toString());
        scala.collection.immutable.Map<String, MessageId> endTopicOffsets = SpecificPulsarOffset$.MODULE$.getTopicOffsets(end);
        if (this.currentTopicOffsets().isEmpty()) {
            this.currentTopicOffsets_$eq((Option<scala.collection.immutable.Map<String, MessageId>>)new Some(endTopicOffsets));
        }
        if (start.isDefined()) {
            Object object = start.get();
            org.apache.spark.sql.execution.streaming.Offset offset = end;
            if (!(object != null ? !object.equals(offset) : offset != null)) {
                return this.sqlContext.internalCreateDataFrame(this.sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)).setName("empty"), this.schema(), true);
            }
        }
        if ((option = start) instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.execution.streaming.Offset prevBatchEndOffset = (org.apache.spark.sql.execution.streaming.Offset)some.value();
            map = SpecificPulsarOffset$.MODULE$.getTopicOffsets(prevBatchEndOffset);
        } else if (None$.MODULE$.equals(option)) {
            map = this.initialTopicOffsets().topicOffsets();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<String, MessageId> fromTopicOffsets = map;
        String[] sortedExecutors = PulsarSourceUtils$.MODULE$.getSortedExecutorList(this.sc());
        int numExecutors = sortedExecutors.length;
        Set newTopics = (Set)endTopicOffsets.keySet().diff((GenSet)fromTopicOffsets.keySet());
        scala.collection.immutable.Map<String, MessageId> newTopicOffsets = this.pulsarHelper.fetchEarliestOffsets((Seq<String>)newTopics.toSeq());
        Set deletedPartitions = (Set)fromTopicOffsets.keySet().diff((GenSet)endTopicOffsets.keySet());
        Object object = deletedPartitions.nonEmpty() ? this.reportDataLoss().apply((Object)new StringBuilder(41).append(deletedPartitions).append(" are gone. Some data may have been missed").toString()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map newFromTopicOffsets = fromTopicOffsets.$plus$plus(newTopicOffsets);
        Seq offsetRanges = ((SetLike)((TraversableLike)endTopicOffsets.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            MessageId fromOffset = (MessageId)newFromTopicOffsets.getOrElse(tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append((String)tp).append(" doesn't have a from offset").toString());
            });
            MessageId untilOffset = (MessageId)endTopicOffsets.apply(tp);
            None$ preferredLoc = numExecutors > 0 ? new Some((Object)sortedExecutors[Math.floorMod(tp.hashCode(), numExecutors)]) : None$.MODULE$;
            return PulsarOffsetRange$.MODULE$.apply((String)tp, fromOffset, untilOffset, (Option<String>)preferredLoc);
        }, Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)range -> BoxesRunTime.boxToBoolean((boolean)PulsarSource.$anonfun$getBatch$4(this, range)))).toSeq();
        PulsarSourceRDD rdd = new PulsarSourceRDD(this.sc(), new SchemaInfoSerializable(this.pulsarSchema()), this.clientConf, this.readerConf, (Seq<PulsarOffsetRange>)offsetRanges, this.pollTimeoutMs, this.failOnDataLoss, this.subscriptionNamePrefix, this.jsonOptions, this.rowsBytesAccumulator(), (Option<String>)this.sqlContext.sparkContext().conf().getOption(PulsarClientFactory$.MODULE$.PulsarClientFactoryClassOption()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(((TraversableOnce)offsetRanges.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString());
        return this.sqlContext.internalCreateDataFrame(rdd.setName("pulsar"), this.schema(), true);
    }

    public void commit(org.apache.spark.sql.execution.streaming.Offset end) {
        scala.collection.immutable.Map<String, MessageId> off = SpecificPulsarOffset$.MODULE$.getTopicOffsets(end);
        this.pulsarHelper.commitCursorToOffset(off);
    }

    public java.util.Map<String, String> metrics(Optional<Offset> optional) {
        java.util.Map currBatchMetrics = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numInputRows"), (Object)Long.toString(this.rowsBytesAccumulator().count())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numInputBytes"), (Object)this.rowsBytesAccumulator().value().toString()), (List)Nil$.MODULE$))).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.rowsBytesAccumulator().reset();
        return currBatchMetrics;
    }

    public synchronized void stop() {
        if (!this.stopped()) {
            this.pulsarHelper.removeCursor();
            this.pulsarHelper.close();
            this.stopped_$eq(true);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getBatch$4(PulsarSource $this, PulsarOffsetRange range) {
        if (range.untilOffset().compareTo(range.fromOffset()) < 0) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)range.fromOffset();
            MessageId messageId = MessageId.latest;
            if (messageIdImpl == null ? messageId != null : !((Object)messageIdImpl).equals(messageId)) {
                $this.reportDataLoss().apply((Object)new StringBuilder(64).append(range.topic()).append("'s offset was changed ").append("from ").append(range.fromOffset()).append(" to ").append(range.untilOffset()).append(", ").append("some data might has been missed").toString());
                return false;
            }
        }
        if (range.untilOffset().compareTo(range.fromOffset()) < 0) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)range.fromOffset();
            MessageId messageId = MessageId.latest;
            if (!(messageIdImpl != null ? !((Object)messageIdImpl).equals(messageId) : messageId != null)) {
                return false;
            }
        }
        return true;
    }

    public PulsarSource(SQLContext sqlContext, PulsarHelper pulsarHelper, java.util.Map<String, Object> clientConf, java.util.Map<String, Object> readerConf, String metadataPath, PerTopicOffset startingOffsets, int pollTimeoutMs, long maxBytesPerTrigger, boolean failOnDataLoss, String subscriptionNamePrefix, JSONOptionsInRead jsonOptions) {
        this.sqlContext = sqlContext;
        this.pulsarHelper = pulsarHelper;
        this.clientConf = clientConf;
        this.readerConf = readerConf;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.pollTimeoutMs = pollTimeoutMs;
        this.maxBytesPerTrigger = maxBytesPerTrigger;
        this.failOnDataLoss = failOnDataLoss;
        this.subscriptionNamePrefix = subscriptionNamePrefix;
        this.jsonOptions = jsonOptions;
        Source.$init$((Source)this);
        Logging.$init$((Logging)this);
        this.sc = sqlContext.sparkContext();
        this.reportDataLoss = PulsarSourceUtils$.MODULE$.reportDataLossFunc(failOnDataLoss);
        this.stopped = false;
        this.currentTopicOffsets = None$.MODULE$;
        LongAccumulator accumulator = new LongAccumulator();
        sqlContext.sparkContext().register((AccumulatorV2)accumulator, "pulsarLatestMicroBatchRowsBytesCounter");
        this.rowsBytesAccumulator = accumulator;
    }
}

