/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.pulsar.JsonUtils$;
import org.apache.spark.sql.pulsar.PerTopicOffset;
import org.apache.spark.sql.pulsar.PulsarHelper;
import org.apache.spark.sql.pulsar.PulsarMicroBatchEmptyInputPartitionReader$;
import org.apache.spark.sql.pulsar.PulsarMicroBatchInputPartition;
import org.apache.spark.sql.pulsar.PulsarMicroBatchInputPartitionReader;
import org.apache.spark.sql.pulsar.PulsarOffsetRange;
import org.apache.spark.sql.pulsar.PulsarOffsetRange$;
import org.apache.spark.sql.pulsar.PulsarSourceInitialOffsetWriter;
import org.apache.spark.sql.pulsar.PulsarSourceUtils$;
import org.apache.spark.sql.pulsar.SchemaInfoSerializable;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset;
import org.apache.spark.sql.pulsar.SpecificPulsarOffset$;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\u0010!\u0001\u0001R\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t=\u0002\u0011\t\u0011)A\u0005!\"Aq\f\u0001B\u0001B\u0003%\u0001\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u00115\u0004!\u0011!Q\u0001\n9DQA\u001e\u0001\u0005\u0002]D1\"!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\b!Y\u0011q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0011\u0011-\ti\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0003\t\u0017\u0005=\u0002\u00011AA\u0002\u0013%\u0011q\u0001\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0004C\u0006\u00028\u0001\u0001\r\u0011!Q!\n\u0005%\u0001\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0004\u0002D\u0001\u0001\u000b\u0015B5\t\u0013\u0005\u0015\u0003A1A\u0005\u0002\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u0015\u0005E\u0003\u0001#b\u0001\n\u0013\t\u0019\u0006C\u0004\u0002\\\u0001!\t%!\u0018\t\u0015\u0005\u001d\u0004\u0001#b\u0001\n\u0003\tI\u0007C\u0004\u0002|\u0001!\t%! \t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003O\u0003A\u0011IAS\u0011\u001d\tI\u000b\u0001C!\u0003W\u0013a\u0003U;mg\u0006\u0014X*[2s_\n\u000bGo\u00195SK\u0006$WM\u001d\u0006\u0003C\t\na\u0001];mg\u0006\u0014(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sON!\u0001aK\u001a>!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003mC:<'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012aa\u00142kK\u000e$\bC\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u0003%\u0019HO]3b[&twM\u0003\u00029s\u0005!!/Z1e\u0015\tQ$%A\u0005d_:tWm\u0019;pe&\u0011A(\u000e\u0002\u0011\u001b&\u001c'o\u001c\"bi\u000eD7\u000b\u001e:fC6\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0013\u0002\u0011%tG/\u001a:oC2L!AQ \u0003\u000f1{wmZ5oO\u0006a\u0001/\u001e7tCJDU\r\u001c9fe\u000e\u0001\u0001C\u0001$H\u001b\u0005\u0001\u0013B\u0001%!\u00051\u0001V\u000f\\:be\"+G\u000e]3s\u0003)\u0019G.[3oi\u000e{gN\u001a\t\u0005\u0017:\u00036&D\u0001M\u0015\tiu&\u0001\u0003vi&d\u0017BA(M\u0005\ri\u0015\r\u001d\t\u0003#js!A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0005U#\u0015A\u0002\u001fs_>$hHC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIf+\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-W\u0003)\u0011X-\u00193fe\u000e{gNZ\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f[\u0001\u0010gR\f'\u000f^5oO>3gm]3ugB\u0011a)Y\u0005\u0003E\u0002\u0012a\u0002U3s)>\u0004\u0018nY(gMN,G/A\u0007q_2dG+[7f_V$Xj\u001d\t\u0003K\u001al\u0011AV\u0005\u0003OZ\u00131!\u00138u\u000391\u0017-\u001b7P]\u0012\u000bG/\u0019'pgN\u0004\"!\u001a6\n\u0005-4&a\u0002\"p_2,\u0017M\\\u0001\u0017gV\u00147o\u0019:jaRLwN\u001c(b[\u0016\u0004&/\u001a4jq\u0006Y!n]8o\u001fB$\u0018n\u001c8t!\tyG/D\u0001q\u0015\t\t(/\u0001\u0003kg>t'BA:#\u0003!\u0019\u0017\r^1msN$\u0018BA;q\u0005EQ5k\u0014(PaRLwN\\:J]J+\u0017\rZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019aL(p\u001f?~}~\f\t!a\u0001\u0011\u0005\u0019\u0003\u0001\"B\"\u000b\u0001\u0004)\u0005\"B%\u000b\u0001\u0004Q\u0005\"B/\u000b\u0001\u0004Q\u0005\"\u00020\u000b\u0001\u0004\u0001\u0006\"B0\u000b\u0001\u0004\u0001\u0007\"B2\u000b\u0001\u0004!\u0007\"\u00025\u000b\u0001\u0004I\u0007\"\u00027\u000b\u0001\u0004\u0001\u0006\"B7\u000b\u0001\u0004q\u0017!E:uCJ$Hk\u001c9jG>3gm]3ugV\u0011\u0011\u0011\u0002\t\u0007#\u0006-\u0001+!\u0004\n\u0005=c\u0006\u0003BA\b\u00037i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0004CBL'\u0002BA\f\u00033\taa\u00197jK:$(BA\u0011'\u0013\u0011\ti\"!\u0005\u0003\u00135+7o]1hK&#\u0017!F:uCJ$Hk\u001c9jG>3gm]3ug~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002f\u0003KI1!a\nW\u0005\u0011)f.\u001b;\t\u0013\u0005-B\"!AA\u0002\u0005%\u0011a\u0001=%c\u0005\u00112\u000f^1siR{\u0007/[2PM\u001a\u001cX\r^:!\u0003=)g\u000e\u001a+pa&\u001cwJ\u001a4tKR\u001c\u0018aE3oIR{\u0007/[2PM\u001a\u001cX\r^:`I\u0015\fH\u0003BA\u0012\u0003kA\u0011\"a\u000b\u0010\u0003\u0003\u0005\r!!\u0003\u0002!\u0015tG\rV8qS\u000e|eMZ:fiN\u0004\u0013aB:u_B\u0004X\rZ\u000b\u0002S\u0006Y1\u000f^8qa\u0016$w\fJ3r)\u0011\t\u0019#!\u0011\t\u0011\u0005-\"#!AA\u0002%\f\u0001b\u001d;paB,G\rI\u0001\u000fe\u0016\u0004xN\u001d;ECR\fGj\\:t+\t\tI\u0005\u0005\u0004f\u0003\u0017\u0002\u00161E\u0005\u0004\u0003\u001b2&!\u0003$v]\u000e$\u0018n\u001c82\u0003=\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004\u0013aE5oSRL\u0017\r\u001c+pa&\u001cwJ\u001a4tKR\u001cXCAA+!\r1\u0015qK\u0005\u0004\u00033\u0002#\u0001F*qK\u000eLg-[2Qk2\u001c\u0018M](gMN,G/A\teKN,'/[1mSj,wJ\u001a4tKR$B!a\u0018\u0002fA\u0019A'!\u0019\n\u0007\u0005\rTG\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\u0006c^\u0001\r\u0001U\u0001\raVd7/\u0019:TG\",W.Y\u000b\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(\u0001\u0004tG\",W.\u0019\u0006\u0005\u0003k\nI\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003s\nyG\u0001\u0006TG\",W.Y%oM>\f1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$b!a \u0002\u000e\u0006E\u0005#B3\u0002\u0002\u0006\u0015\u0015bAAB-\n)\u0011I\u001d:bsB!\u0011qQAE\u001b\u00059\u0014bAAFo\tq\u0011J\u001c9viB\u000b'\u000f^5uS>t\u0007bBAH3\u0001\u0007\u0011qL\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003'K\u0002\u0019AA0\u0003\r)g\u000eZ\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002$\u0005\u00192M]3bi\u0016\u0014V-\u00193fe\u001a\u000b7\r^8ssR\u0011\u0011Q\u0014\t\u0005\u0003\u000f\u000by*C\u0002\u0002\"^\u0012a\u0003U1si&$\u0018n\u001c8SK\u0006$WM\u001d$bGR|'/_\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\u0015\u0005\u0005}\u0013\u0001\u00047bi\u0016\u001cHo\u00144gg\u0016$\u0018AB2p[6LG\u000f\u0006\u0003\u0002$\u00055\u0006bBAJ=\u0001\u0007\u0011q\f")
public class PulsarMicroBatchReader
implements MicroBatchStream,
Logging {
    private SpecificPulsarOffset initialTopicOffsets;
    private SchemaInfo pulsarSchema;
    private final PulsarHelper pulsarHelper;
    public final Map<String, Object> org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$clientConf;
    public final Map<String, Object> org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$readerConf;
    private final String metadataPath;
    private PerTopicOffset startingOffsets;
    public final int org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$pollTimeoutMs;
    public final boolean org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$failOnDataLoss;
    public final String org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$subscriptionNamePrefix;
    public final JSONOptionsInRead org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$jsonOptions;
    private scala.collection.immutable.Map<String, MessageId> startTopicOffsets;
    private scala.collection.immutable.Map<String, MessageId> endTopicOffsets;
    private boolean stopped;
    private final Function1<String, BoxedUnit> reportDataLoss;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private scala.collection.immutable.Map<String, MessageId> startTopicOffsets() {
        return this.startTopicOffsets;
    }

    private void startTopicOffsets_$eq(scala.collection.immutable.Map<String, MessageId> x$1) {
        this.startTopicOffsets = x$1;
    }

    private scala.collection.immutable.Map<String, MessageId> endTopicOffsets() {
        return this.endTopicOffsets;
    }

    private void endTopicOffsets_$eq(scala.collection.immutable.Map<String, MessageId> x$1) {
        this.endTopicOffsets = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public Function1<String, BoxedUnit> reportDataLoss() {
        return this.reportDataLoss;
    }

    private SpecificPulsarOffset initialTopicOffsets$lzycompute() {
        PulsarMicroBatchReader pulsarMicroBatchReader = this;
        synchronized (pulsarMicroBatchReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                PulsarSourceInitialOffsetWriter metadataLog = new PulsarSourceInitialOffsetWriter((SparkSession)SparkSession$.MODULE$.getActiveSession().get(), this.metadataPath);
                this.initialTopicOffsets = metadataLog.getInitialOffset(this.pulsarHelper, this.startingOffsets, this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$pollTimeoutMs, this.reportDataLoss());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.startingOffsets = null;
        return this.initialTopicOffsets;
    }

    private SpecificPulsarOffset initialTopicOffsets() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.initialTopicOffsets$lzycompute();
        }
        return this.initialTopicOffsets;
    }

    public Offset deserializeOffset(String json) {
        return new SpecificPulsarOffset(JsonUtils$.MODULE$.topicOffsets(json));
    }

    private SchemaInfo pulsarSchema$lzycompute() {
        PulsarMicroBatchReader pulsarMicroBatchReader = this;
        synchronized (pulsarMicroBatchReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.pulsarSchema = this.pulsarHelper.getPulsarSchema();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pulsarSchema;
    }

    public SchemaInfo pulsarSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.pulsarSchema$lzycompute();
        }
        return this.pulsarSchema;
    }

    public InputPartition[] planInputPartitions(Offset start, Offset end) {
        Set newPartitions = (Set)this.endTopicOffsets().keySet().diff((GenSet)this.startTopicOffsets().keySet());
        scala.collection.immutable.Map<String, MessageId> newPartitionInitialOffsets = this.pulsarHelper.fetchEarliestOffsets((Seq<String>)newPartitions.toSeq());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Topics added: ").append(newPartitions).toString());
        Set deletedPartitions = (Set)this.startTopicOffsets().keySet().diff((GenSet)this.endTopicOffsets().keySet());
        Object object = deletedPartitions.nonEmpty() ? this.reportDataLoss().apply((Object)new StringBuilder(41).append(deletedPartitions).append(" are gone. Some data may have been missed").toString()) : BoxedUnit.UNIT;
        scala.collection.immutable.Map newStartsOffsets = this.startTopicOffsets().$plus$plus(newPartitionInitialOffsets);
        Seq offsetRanges = ((SetLike)((TraversableLike)this.endTopicOffsets().keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            MessageId fromOffset = (MessageId)newStartsOffsets.getOrElse(tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(28).append((String)tp).append(" doesn't have a start offset").toString());
            });
            MessageId untilOffset = (MessageId)this.endTopicOffsets().apply(tp);
            String[] sortedExecutors = PulsarSourceUtils$.MODULE$.getSortedExecutorList();
            int numExecutors = sortedExecutors.length;
            None$ preferredLoc = numExecutors > 0 ? new Some((Object)sortedExecutors[Math.floorMod(tp.hashCode(), numExecutors)]) : None$.MODULE$;
            return PulsarOffsetRange$.MODULE$.apply((String)tp, fromOffset, untilOffset, (Option<String>)preferredLoc);
        }, Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)range -> BoxesRunTime.boxToBoolean((boolean)PulsarMicroBatchReader.$anonfun$planInputPartitions$4(this, range)))).toSeq();
        return (InputPartition[])((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> new PulsarMicroBatchInputPartition((PulsarOffsetRange)range, new SchemaInfoSerializable(this.pulsarSchema()), $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$clientConf, $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$readerConf, $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$pollTimeoutMs, $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$failOnDataLoss, $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$subscriptionNamePrefix, $this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$jsonOptions), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public synchronized void stop() {
        if (!this.stopped()) {
            this.pulsarHelper.removeCursor();
            this.pulsarHelper.close();
            this.stopped_$eq(true);
            return;
        }
    }

    public PartitionReaderFactory createReaderFactory() {
        return new PartitionReaderFactory(this){
            private final /* synthetic */ PulsarMicroBatchReader $outer;

            public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition x$1) {
                return super.createColumnarReader(x$1);
            }

            public boolean supportColumnarReads(InputPartition x$1) {
                return super.supportColumnarReads(x$1);
            }

            public PartitionReader<InternalRow> createReader(InputPartition partition) {
                PulsarOffsetRange range = ((PulsarMicroBatchInputPartition)partition).range();
                MessageId start = range.fromOffset();
                MessageId end = range.untilOffset();
                MessageId messageId = start;
                MessageId messageId2 = end;
                if (!(messageId == null ? messageId2 != null : !messageId.equals(messageId2)) || !PulsarSourceUtils$.MODULE$.messageExists(end)) {
                    return PulsarMicroBatchEmptyInputPartitionReader$.MODULE$;
                }
                return new PulsarMicroBatchInputPartitionReader(range, new SchemaInfoSerializable(this.$outer.pulsarSchema()), this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$clientConf, this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$readerConf, this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$pollTimeoutMs, this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$failOnDataLoss, this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$subscriptionNamePrefix, this.$outer.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$jsonOptions);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Offset initialOffset() {
        return new SpecificPulsarOffset(this.startTopicOffsets());
    }

    public Offset latestOffset() {
        return new SpecificPulsarOffset(this.endTopicOffsets());
    }

    public void commit(Offset end) {
        scala.collection.immutable.Map<String, MessageId> endTopicOffsets = SpecificPulsarOffset$.MODULE$.getTopicOffsets((org.apache.spark.sql.execution.streaming.Offset)end);
        this.pulsarHelper.commitCursorToOffset(endTopicOffsets);
    }

    public static final /* synthetic */ boolean $anonfun$planInputPartitions$4(PulsarMicroBatchReader $this, PulsarOffsetRange range) {
        if (range.untilOffset().compareTo(range.fromOffset()) < 0) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)range.fromOffset();
            MessageId messageId = MessageId.latest;
            if (messageIdImpl == null ? messageId != null : !((Object)messageIdImpl).equals(messageId)) {
                $this.reportDataLoss().apply((Object)new StringBuilder(64).append(range.topic()).append("'s offset was changed ").append("from ").append(range.fromOffset()).append(" to ").append(range.untilOffset()).append(", ").append("some data might has been missed").toString());
                return false;
            }
        }
        if (range.untilOffset().compareTo(range.fromOffset()) < 0) {
            MessageIdImpl messageIdImpl = (MessageIdImpl)range.fromOffset();
            MessageId messageId = MessageId.latest;
            if (!(messageIdImpl != null ? !((Object)messageIdImpl).equals(messageId) : messageId != null)) {
                return false;
            }
        }
        return true;
    }

    public PulsarMicroBatchReader(PulsarHelper pulsarHelper, Map<String, Object> clientConf, Map<String, Object> readerConf, String metadataPath, PerTopicOffset startingOffsets, int pollTimeoutMs, boolean failOnDataLoss, String subscriptionNamePrefix, JSONOptionsInRead jsonOptions) {
        this.pulsarHelper = pulsarHelper;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$clientConf = clientConf;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$readerConf = readerConf;
        this.metadataPath = metadataPath;
        this.startingOffsets = startingOffsets;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$pollTimeoutMs = pollTimeoutMs;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$failOnDataLoss = failOnDataLoss;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$subscriptionNamePrefix = subscriptionNamePrefix;
        this.org$apache$spark$sql$pulsar$PulsarMicroBatchReader$$jsonOptions = jsonOptions;
        Logging.$init$((Logging)this);
        this.stopped = false;
        this.reportDataLoss = PulsarSourceUtils$.MODULE$.reportDataLossFunc(failOnDataLoss);
    }
}

