/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.shade.javax.ws.rs.ClientErrorException;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends BaseResource
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final WebTarget workerStats;
    private final WebTarget worker;

    public WorkerImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.worker = web.path("/admin/v2/worker");
        this.workerStats = web.path("/admin/v2/worker-stats");
    }

    @Override
    public List<WorkerFunctionInstanceStats> getFunctionsStats() throws PulsarAdminException {
        return (List)this.sync(() -> this.getFunctionsStatsAsync());
    }

    @Override
    public CompletableFuture<List<WorkerFunctionInstanceStats>> getFunctionsStatsAsync() {
        WebTarget path = this.workerStats.path("functionsmetrics");
        final CompletableFuture<List<WorkerFunctionInstanceStats>> future = new CompletableFuture<List<WorkerFunctionInstanceStats>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    List<WorkerFunctionInstanceStats> metricsList = response.readEntity(new GenericType<List<WorkerFunctionInstanceStats>>(){});
                    future.complete(metricsList);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Collection<Metrics> getMetrics() throws PulsarAdminException {
        return (Collection)this.sync(() -> this.getMetricsAsync());
    }

    @Override
    public CompletableFuture<Collection<Metrics>> getMetricsAsync() {
        WebTarget path = this.workerStats.path("metrics");
        final CompletableFuture<Collection<Metrics>> future = new CompletableFuture<Collection<Metrics>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete((Collection)response.readEntity(new GenericType<List<Metrics>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        return (List)this.sync(() -> this.getClusterAsync());
    }

    @Override
    public CompletableFuture<List<WorkerInfo>> getClusterAsync() {
        WebTarget path = this.worker.path("cluster");
        final CompletableFuture<List<WorkerInfo>> future = new CompletableFuture<List<WorkerInfo>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<WorkerInfo>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public WorkerInfo getClusterLeader() throws PulsarAdminException {
        return (WorkerInfo)this.sync(() -> this.getClusterLeaderAsync());
    }

    @Override
    public CompletableFuture<WorkerInfo> getClusterLeaderAsync() {
        WebTarget path = this.worker.path("cluster").path("leader");
        final CompletableFuture<WorkerInfo> future = new CompletableFuture<WorkerInfo>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<WorkerInfo>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public Map<String, Collection<String>> getAssignments() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getAssignmentsAsync());
    }

    @Override
    public CompletableFuture<Map<String, Collection<String>>> getAssignmentsAsync() {
        WebTarget path = this.worker.path("assignments");
        final CompletableFuture<Map<String, Collection<String>>> future = new CompletableFuture<Map<String, Collection<String>>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(new ClientErrorException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<Map<String, Collection<String>>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(WorkerImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void rebalance() throws PulsarAdminException {
        this.sync(this::rebalanceAsync);
    }

    @Override
    public CompletableFuture<Void> rebalanceAsync() {
        WebTarget path = this.worker.path("rebalance");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }
}

