/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.MalformedInputException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\n\u0014\u0001yA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011)\u0019!C\u0001g!AA\b\u0001B\u0001B\u0003%A\u0007C\u0003>\u0001\u0011\u0005a(\u0002\u0003D\u0001\u0011!\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00079\u0002\u0001\u000b\u0011B+\t\u000fu\u0003!\u0019!C\u0005=\"1!\r\u0001Q\u0001\n}CQa\u0019\u0001\u0005\n\u0011DQA\u001b\u0001\u0005\u0002-DQ\u0001\u001d\u0001\u0005\nEDq!!\u0006\u0001\t\u0013\t9\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0002\u0014\u0015\u0006\u001c7n]8o%\u0016\u001cwN\u001d3QCJ\u001cXM\u001d\u0006\u0003)U\ta\u0001];mg\u0006\u0014(B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\f\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\u000611o\u00195f[\u0006\u0004\"!\f\u0019\u000e\u00039R!aL\u000b\u0002\u000bQL\b/Z:\n\u0005Er#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u000f=\u0004H/[8ogV\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005!!n]8o\u0015\tIT#\u0001\u0005dCR\fG._:u\u0013\tYdGA\u0006K'>su\n\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\ry\u0014I\u0011\t\u0003\u0001\u0002i\u0011a\u0005\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006e\u0011\u0001\r\u0001\u000e\u0002\u000f-\u0006dW/Z\"p]Z,'\u000f^3s!\u0011\u0001SiR\u0010\n\u0005\u0019\u000b#!\u0003$v]\u000e$\u0018n\u001c82!\tA\u0015+D\u0001J\u0015\tQ5*\u0001\u0003d_J,'B\u0001'N\u0003\u001dQ\u0017mY6t_:T!AT(\u0002\u0013\u0019\f7\u000f^3sq6d'\"\u0001)\u0002\u0007\r|W.\u0003\u0002S\u0013\nQ!j]8o!\u0006\u00148/\u001a:\u0002\u001bI|w\u000e^\"p]Z,'\u000f^3s+\u0005)\u0006#\u0002\u0011W\u000fbC\u0016BA,\"\u0005%1UO\\2uS>t'\u0007\u0005\u0002Z56\t\u0001(\u0003\u0002\\q\tY\u0011J\u001c;fe:\fGNU8x\u00039\u0011xn\u001c;D_:4XM\u001d;fe\u0002\nqAZ1di>\u0014\u00180F\u0001`!\tA\u0005-\u0003\u0002b\u0013\nY!j]8o\r\u0006\u001cGo\u001c:z\u0003!1\u0017m\u0019;pef\u0004\u0013aF7bW\u0016\u001cFO];diJ{w\u000e^\"p]Z,'\u000f^3s)\t)V\rC\u0003g\u0015\u0001\u0007q-\u0001\u0002tiB\u0011Q\u0006[\u0005\u0003S:\u0012!b\u0015;sk\u000e$H+\u001f9f\u00035i\u0017m[3D_:4XM\u001d;feR\u0011AN\u001c\t\u0003[\u0016i\u0011\u0001\u0001\u0005\u0006_.\u0001\r\u0001L\u0001\tI\u0006$\u0018\rV=qK\u0006q\u0001/\u0019:tK*\u001bxN\u001c+pW\u0016tWC\u0001:w)\u0015\u0019\u0018qBA\n)\t!x\u0010\u0005\u0002vm2\u0001A!B<\r\u0005\u0004A(!\u0001*\u0012\u0005ed\bC\u0001\u0011{\u0013\tY\u0018E\u0001\u0003Ok2d\u0007C\u0001\u0011~\u0013\tq\u0018EA\u0002B]fDq!!\u0001\r\u0001\u0004\t\u0019!A\u0001g!\u0019\u0001\u0013QAA\u0005i&\u0019\u0011qA\u0011\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042\u0001SA\u0006\u0013\r\ti!\u0013\u0002\n\u0015N|g\u000eV8lK:Da!!\u0005\r\u0001\u00049\u0015A\u00029beN,'\u000fC\u0003p\u0019\u0001\u0007A&\u0001\tgC&dW\rZ\"p]Z,'o]5p]V!\u0011\u0011DA\u0010)\u0019\tY\"!\t\u0002$A9\u0001%!\u0002\u0002\n\u0005u\u0001cA;\u0002 \u0011)q/\u0004b\u0001q\"1\u0011\u0011C\u0007A\u0002\u001dCQa\\\u0007A\u00021\nQbY8om\u0016\u0014Ho\u00142kK\u000e$H#\u0003-\u0002*\u0005-\u0012QFA\u001c\u0011\u0019\t\tB\u0004a\u0001\u000f\")1F\u0004a\u0001O\"9\u0011q\u0006\bA\u0002\u0005E\u0012a\u00044jK2$7i\u001c8wKJ$XM]:\u0011\t\u0001\n\u0019\u0004\\\u0005\u0004\u0003k\t#!B!se\u0006L\bBBA\u001d\u001d\u0001\u0007\u0001,A\u0002s_^\f!bY8om\u0016\u0014H/T1q)\u0019\ty$a\u0013\u0002NA!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fa\nA!\u001e;jY&!\u0011\u0011JA\"\u0005\u001di\u0015\r\u001d#bi\u0006Da!!\u0005\u0010\u0001\u00049\u0005BBA(\u001f\u0001\u0007A.\u0001\bgS\u0016dGmQ8om\u0016\u0014H/\u001a:\u0002\u0019\r|gN^3si\u0006\u0013(/Y=\u0015\r\u0005U\u00131LA/!\u0011\t\t%a\u0016\n\t\u0005e\u00131\t\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006Da!!\u0005\u0011\u0001\u00049\u0005BBA(!\u0001\u0007A.A\u0003qCJ\u001cX-\u0006\u0003\u0002d\u0005-D#\u0003-\u0002f\u0005]\u0014QPAI\u0011\u001d\t9'\u0005a\u0001\u0003S\naA]3d_J$\u0007cA;\u0002l\u00119\u0011QN\tC\u0002\u0005=$!\u0001+\u0012\u0007\u0005ED\u0010E\u0002!\u0003gJ1!!\u001e\"\u0005\u001dqu\u000e\u001e5j]\u001eDq!!\u001f\u0012\u0001\u0004\tY(\u0001\u0007de\u0016\fG/\u001a)beN,'\u000f\u0005\u0004!-~\u000bIg\u0012\u0005\b\u0003\u007f\n\u0002\u0019AAA\u00035\u0011XmY8sI2KG/\u001a:bYB1\u0001%RA5\u0003\u0007\u0003B!!\"\u0002\u000e6\u0011\u0011q\u0011\u0006\u0004_\u0005%%bAAF/\u00051QO\\:bM\u0016LA!a$\u0002\b\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\t\r\u0005e\u0012\u00031\u0001Y\u0001")
public class JacksonRecordParser
implements Logging {
    private final JSONOptions options;
    private final Function2<JsonParser, InternalRow, InternalRow> rootConverter;
    private final JsonFactory org$apache$spark$sql$pulsar$JacksonRecordParser$$factory;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public JSONOptions options() {
        return this.options;
    }

    private Function2<JsonParser, InternalRow, InternalRow> rootConverter() {
        return this.rootConverter;
    }

    public JsonFactory org$apache$spark$sql$pulsar$JacksonRecordParser$$factory() {
        return this.org$apache$spark$sql$pulsar$JacksonRecordParser$$factory;
    }

    private Function2<JsonParser, InternalRow, InternalRow> makeStructRootConverter(StructType st) {
        Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)st.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        return (Function2 & Serializable & scala.Serializable)(parser, row) -> (InternalRow)this.parseJsonToken((JsonParser)parser, (DataType)st, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, st, fieldConverters, (InternalRow)row){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonRecordParser $outer;
            private final JsonParser parser$1;
            private final StructType st$1;
            private final Function1[] fieldConverters$1;
            private final InternalRow row$1;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (JsonToken.START_OBJECT.equals(A1)) {
                    return (B1)this.$outer.org$apache$spark$sql$pulsar$JacksonRecordParser$$convertObject(this.parser$1, this.st$1, this.fieldConverters$1, this.row$1);
                }
                if (JsonToken.START_ARRAY.equals(A1)) {
                    throw new IllegalStateException("Message should be a single JSON object");
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                if (JsonToken.START_OBJECT.equals(jsonToken)) {
                    return true;
                }
                return JsonToken.START_ARRAY.equals(jsonToken);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.parser$1 = parser$1;
                this.st$1 = st$1;
                this.fieldConverters$1 = fieldConverters$1;
                this.row$1 = row$1;
            }
        });
    }

    public Function1<JsonParser, Object> makeConverter(DataType dataType2) {
        DataType dataType3 = dataType2;
        if (BooleanType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Boolean)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (JsonToken.VALUE_TRUE.equals(A1)) {
                        return (B1)Predef$.MODULE$.boolean2Boolean(true);
                    }
                    if (JsonToken.VALUE_FALSE.equals(A1)) {
                        return (B1)Predef$.MODULE$.boolean2Boolean(false);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(JsonToken x1) {
                    JsonToken jsonToken = x1;
                    if (JsonToken.VALUE_TRUE.equals(jsonToken)) {
                        return true;
                    }
                    return JsonToken.VALUE_FALSE.equals(jsonToken);
                }
            });
        }
        if (ByteType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Byte)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1)) {
                        return (B1)Predef$.MODULE$.byte2Byte(this.parser$2.getByteValue());
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(JsonToken x2) {
                    JsonToken jsonToken = x2;
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                }
                {
                    this.parser$2 = parser$2;
                }
            });
        }
        if (ShortType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Short)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$3;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1)) {
                        return (B1)Predef$.MODULE$.short2Short(this.parser$3.getShortValue());
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(JsonToken x3) {
                    JsonToken jsonToken = x3;
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                }
                {
                    this.parser$3 = parser$3;
                }
            });
        }
        if (IntegerType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Integer)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$4;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1)) {
                        return (B1)Predef$.MODULE$.int2Integer(this.parser$4.getIntValue());
                    }
                    return (B1)function1.apply(x4);
                }

                public final boolean isDefinedAt(JsonToken x4) {
                    JsonToken jsonToken = x4;
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                }
                {
                    this.parser$4 = parser$4;
                }
            });
        }
        if (LongType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$5;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    A1 A1 = x5;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1)) {
                        return (B1)Predef$.MODULE$.long2Long(this.parser$5.getLongValue());
                    }
                    return (B1)function1.apply(x5);
                }

                public final boolean isDefinedAt(JsonToken x5) {
                    JsonToken jsonToken = x5;
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                }
                {
                    this.parser$5 = parser$5;
                }
            });
        }
        if (FloatType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Float)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$6;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    A1 A1 = x6;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1)) {
                        return (B1)Predef$.MODULE$.float2Float(this.parser$6.getFloatValue());
                    }
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String string = this.parser$6.getText();
                        if ("NaN".equals(string)) {
                            return (B1)Predef$.MODULE$.float2Float(Float.NaN);
                        }
                        if ("Infinity".equals(string)) {
                            return (B1)Predef$.MODULE$.float2Float(Float.POSITIVE_INFINITY);
                        }
                        if ("-Infinity".equals(string)) {
                            return (B1)Predef$.MODULE$.float2Float(Float.NEGATIVE_INFINITY);
                        }
                        throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(FloatType$.MODULE$.catalogString()).append(".").toString());
                    }
                    return (B1)function1.apply(x6);
                }

                public final boolean isDefinedAt(JsonToken x6) {
                    JsonToken jsonToken = x6;
                    if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken)) {
                        return true;
                    }
                    return JsonToken.VALUE_STRING.equals(jsonToken);
                }
                {
                    this.parser$6 = parser$6;
                }
            });
        }
        if (DoubleType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Double)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$7;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    A1 A1 = x7;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1)) {
                        return (B1)Predef$.MODULE$.double2Double(this.parser$7.getDoubleValue());
                    }
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String string = this.parser$7.getText();
                        if ("NaN".equals(string)) {
                            return (B1)Predef$.MODULE$.double2Double(Double.NaN);
                        }
                        if ("Infinity".equals(string)) {
                            return (B1)Predef$.MODULE$.double2Double(Double.POSITIVE_INFINITY);
                        }
                        if ("-Infinity".equals(string)) {
                            return (B1)Predef$.MODULE$.double2Double(Double.NEGATIVE_INFINITY);
                        }
                        throw new RuntimeException(new StringBuilder(18).append("Cannot parse ").append(string).append(" as ").append(DoubleType$.MODULE$.catalogString()).append(".").toString());
                    }
                    return (B1)function1.apply(x7);
                }

                public final boolean isDefinedAt(JsonToken x7) {
                    JsonToken jsonToken = x7;
                    if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken)) {
                        return true;
                    }
                    return JsonToken.VALUE_STRING.equals(jsonToken);
                }
                {
                    this.parser$7 = parser$7;
                }
            });
        }
        if (StringType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (UTF8String)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final JsonParser parser$8;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    A1 A1 = x8;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        return (B1)UTF8String.fromString((String)this.parser$8.getText());
                    }
                    ByteArrayOutputStream writer = new ByteArrayOutputStream();
                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.$outer.org$apache$spark$sql$pulsar$JacksonRecordParser$$factory().createGenerator((OutputStream)writer, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                        $anonfun$$nestedInanonfun$makeConverter$8$1.$anonfun$applyOrElse$2(this, generator);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)UTF8String.fromBytes((byte[])writer.toByteArray());
                }

                public final boolean isDefinedAt(JsonToken x8) {
                    JsonToken jsonToken = x8;
                    if (JsonToken.VALUE_STRING.equals(jsonToken)) {
                        return true;
                    }
                    return true;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$$nestedInanonfun$makeConverter$8$1 $this, JsonGenerator generator) {
                    generator.copyCurrentStructure($this.parser$8);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$8 = parser$8;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$8$1 java.io.ByteArrayOutputStream ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$8$1 com.fasterxml.jackson.core.JsonGenerator )}, serializedLambda);
                }
            });
        }
        if (TimestampType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final JsonParser parser$9;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    A1 A1 = x9;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$9.getText();
                        return (B1)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> TimestampFormatter$.MODULE$.apply($this.$outer.options().timestampFormatInWrite(), $this.$outer.options().zoneId(), true).parse(stringValue)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)stringValue), $this.$outer.options().zoneId()).get()))));
                    }
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1)) {
                        return (B1)Predef$.MODULE$.long2Long(this.parser$9.getLongValue() * 1000000L);
                    }
                    return (B1)function1.apply(x9);
                }

                public final boolean isDefinedAt(JsonToken x9) {
                    JsonToken jsonToken = x9;
                    if (JsonToken.VALUE_STRING.equals(jsonToken)) {
                        return true;
                    }
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$9 = parser$9;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$9$1 java.lang.String ), $anonfun$applyOrElse$4(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$9$1 java.lang.String )}, serializedLambda);
                }
            });
        }
        if (DateType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (Long)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final JsonParser parser$10;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    A1 A1 = x10;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        String stringValue = this.parser$10.getText();
                        return (B1)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> TimestampFormatter$.MODULE$.apply($this.$outer.options().timestampFormatInWrite(), $this.$outer.options().zoneId(), true).parse(stringValue)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)stringValue), $this.$outer.options().zoneId()).get()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(stringValue)).toLong())));
                    }
                    return (B1)function1.apply(x10);
                }

                public final boolean isDefinedAt(JsonToken x10) {
                    JsonToken jsonToken = x10;
                    return JsonToken.VALUE_STRING.equals(jsonToken);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$10 = parser$10;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.String ), $anonfun$applyOrElse$6(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.String ), $anonfun$applyOrElse$8(java.lang.String ), $anonfun$applyOrElse$7(org.apache.spark.sql.pulsar.JacksonRecordParser$$anonfun$$nestedInanonfun$makeConverter$10$1 java.lang.String )}, serializedLambda);
                }
            });
        }
        if (BinaryType$.MODULE$.equals(dataType3)) {
            return (Function1 & Serializable & scala.Serializable)parser -> (byte[])this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$11;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    A1 A1 = x11;
                    if (JsonToken.VALUE_STRING.equals(A1)) {
                        return (B1)this.parser$11.getBinaryValue();
                    }
                    return (B1)function1.apply(x11);
                }

                public final boolean isDefinedAt(JsonToken x11) {
                    JsonToken jsonToken = x11;
                    return JsonToken.VALUE_STRING.equals(jsonToken);
                }
                {
                    this.parser$11 = parser$11;
                }
            });
        }
        if (dataType3 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType3;
            return (Function1 & Serializable & scala.Serializable)parser -> (Decimal)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(null, (JsonParser)parser, decimalType){
                public static final long serialVersionUID = 0L;
                private final JsonParser parser$12;
                private final DecimalType x13$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    A1 A1 = x12;
                    if (JsonToken.VALUE_NUMBER_INT.equals(A1) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(A1)) {
                        return (B1)Decimal$.MODULE$.apply(this.parser$12.getDecimalValue(), this.x13$1.precision(), this.x13$1.scale());
                    }
                    return (B1)function1.apply(x12);
                }

                public final boolean isDefinedAt(JsonToken x12) {
                    JsonToken jsonToken = x12;
                    return JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                }
                {
                    this.parser$12 = parser$12;
                    this.x13$1 = x13$1;
                }
            });
        }
        if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            Function1[] fieldConverters = (Function1[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)dataType -> this.makeConverter((DataType)dataType), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
            return (Function1 & Serializable & scala.Serializable)parser -> (InternalRow)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, structType, (JsonParser)parser, fieldConverters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final StructType x14$1;
                private final JsonParser parser$13;
                private final Function1[] fieldConverters$2;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    A1 A1 = x13;
                    if (JsonToken.START_OBJECT.equals(A1)) {
                        GenericInternalRow record = new GenericInternalRow(this.x14$1.length());
                        return (B1)this.$outer.org$apache$spark$sql$pulsar$JacksonRecordParser$$convertObject(this.parser$13, this.x14$1, this.fieldConverters$2, (InternalRow)record);
                    }
                    return (B1)function1.apply(x13);
                }

                public final boolean isDefinedAt(JsonToken x13) {
                    JsonToken jsonToken = x13;
                    return JsonToken.START_OBJECT.equals(jsonToken);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.x14$1 = x14$1;
                    this.parser$13 = parser$13;
                    this.fieldConverters$2 = fieldConverters$2;
                }
            });
        }
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            Function1<JsonParser, Object> elementConverter = this.makeConverter(arrayType.elementType());
            return (Function1 & Serializable & scala.Serializable)parser -> (ArrayData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)elementConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final JsonParser parser$14;
                private final Function1 elementConverter$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    A1 A1 = x14;
                    if (JsonToken.START_ARRAY.equals(A1)) {
                        return (B1)this.$outer.org$apache$spark$sql$pulsar$JacksonRecordParser$$convertArray(this.parser$14, (Function1<JsonParser, Object>)this.elementConverter$1);
                    }
                    return (B1)function1.apply(x14);
                }

                public final boolean isDefinedAt(JsonToken x14) {
                    JsonToken jsonToken = x14;
                    return JsonToken.START_ARRAY.equals(jsonToken);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$14 = parser$14;
                    this.elementConverter$1 = elementConverter$1;
                }
            });
        }
        if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            Function1<JsonParser, Object> valueConverter = this.makeConverter(mapType.valueType());
            return (Function1 & Serializable & scala.Serializable)parser -> (MapData)this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)new scala.Serializable(this, (JsonParser)parser, (Function1)valueConverter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JacksonRecordParser $outer;
                private final JsonParser parser$15;
                private final Function1 valueConverter$1;

                public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    A1 A1 = x15;
                    if (JsonToken.START_OBJECT.equals(A1)) {
                        return (B1)this.$outer.org$apache$spark$sql$pulsar$JacksonRecordParser$$convertMap(this.parser$15, (Function1<JsonParser, Object>)this.valueConverter$1);
                    }
                    return (B1)function1.apply(x15);
                }

                public final boolean isDefinedAt(JsonToken x15) {
                    JsonToken jsonToken = x15;
                    return JsonToken.START_OBJECT.equals(jsonToken);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parser$15 = parser$15;
                    this.valueConverter$1 = valueConverter$1;
                }
            });
        }
        if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            return this.makeConverter(userDefinedType.sqlType());
        }
        return (Function1 & Serializable & scala.Serializable)parser -> this.parseJsonToken((JsonParser)parser, dataType2, (PartialFunction)PartialFunction$.MODULE$.empty());
    }

    private <R> R parseJsonToken(JsonParser parser, DataType dataType, PartialFunction<JsonToken, R> f) {
        JsonToken jsonToken;
        while (JsonToken.FIELD_NAME.equals(jsonToken = parser.getCurrentToken())) {
            parser.nextToken();
        }
        if (jsonToken == null ? true : JsonToken.VALUE_NULL.equals(jsonToken)) {
            return null;
        }
        return (R)f.applyOrElse((Object)jsonToken, this.failedConversion(parser, dataType));
    }

    private <R> PartialFunction<JsonToken, R> failedConversion(JsonParser parser, DataType dataType) {
        return new scala.Serializable(null, parser, dataType){
            public static final long serialVersionUID = 0L;
            private final JsonParser parser$16;
            private final DataType dataType$2;

            public final <A1 extends JsonToken, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (JsonToken.VALUE_STRING.equals(A1) && this.parser$16.getTextLength() < 1) {
                    return null;
                }
                throw new RuntimeException(new StringBuilder(57).append("Failed to parse a value for data type ").append(this.dataType$2.catalogString()).append(" (current token: ").append(A1).append(").").toString());
            }

            public final boolean isDefinedAt(JsonToken x1) {
                JsonToken jsonToken = x1;
                if (JsonToken.VALUE_STRING.equals(jsonToken) && this.parser$16.getTextLength() < 1) {
                    return true;
                }
                return true;
            }
            {
                this.parser$16 = parser$16;
                this.dataType$2 = dataType$2;
            }
        };
    }

    public InternalRow org$apache$spark$sql$pulsar$JacksonRecordParser$$convertObject(JsonParser parser, StructType schema, Function1<JsonParser, Object>[] fieldConverters, InternalRow row) {
        Range allFields = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), schema.fields().length);
        Set nullFields = (Set)Set$.MODULE$.apply((Seq)allFields);
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            Option option = schema.getFieldIndex(parser.getCurrentName());
            if (option instanceof Some) {
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.value());
                nullFields.remove((Object)BoxesRunTime.boxToInteger((int)index));
                row.update(index, fieldConverters[index].apply((Object)parser));
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                parser.skipChildren();
                continue;
            }
            throw new MatchError((Object)option);
        }
        nullFields.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> row.setNullAt(i));
        return row;
    }

    public MapData org$apache$spark$sql$pulsar$JacksonRecordParser$$convertMap(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return ArrayBasedMapData$.MODULE$.apply(keys.toArray(ClassTag$.MODULE$.apply(UTF8String.class)), values.toArray(ClassTag$.MODULE$.Any()));
    }

    public ArrayData org$apache$spark$sql$pulsar$JacksonRecordParser$$convertArray(JsonParser parser, Function1<JsonParser, Object> fieldConverter) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(fieldConverter.apply((Object)parser));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T> InternalRow parse(T record, Function2<JsonFactory, T, JsonParser> createParser, Function1<T, UTF8String> recordLiteral, InternalRow row) {
        InternalRow internalRow;
        try {
            internalRow = (InternalRow)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)this.org$apache$spark$sql$pulsar$JacksonRecordParser$$factory(), record), (Function1 & Serializable & scala.Serializable)parser -> {
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    return InternalRow$.MODULE$.empty();
                }
                InternalRow internalRow = (InternalRow)this.rootConverter().apply(parser, (Object)row);
                if (internalRow == null) {
                    throw new RuntimeException("Root converter returned null");
                }
                return internalRow;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException)) {
                throw new BadRecordException((Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, throwable2);
            }
            if (throwable2 instanceof CharConversionException) {
                CharConversionException charConversionException = (CharConversionException)throwable2;
                if (this.options().encoding().isEmpty()) {
                    String msg = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n            |Specifying encoding as an input option explicitly might help to resolve the issue.\n            |")).stripMargin()).append(charConversionException.getMessage()).toString();
                    CharConversionException wrappedCharException = new CharConversionException(msg);
                    wrappedCharException.initCause(charConversionException);
                    throw new BadRecordException((Function0 & Serializable & scala.Serializable)() -> (UTF8String)recordLiteral.apply(record), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, (Throwable)wrappedCharException);
                }
            }
            throw throwable;
        }
        return internalRow;
    }

    public JacksonRecordParser(DataType schema, JSONOptions options) {
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.assert(schema instanceof StructType);
        this.rootConverter = this.makeStructRootConverter((StructType)schema);
        this.org$apache$spark$sql$pulsar$JacksonRecordParser$$factory = options.buildJsonFactory();
    }
}

