/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pulsar;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaBuilder;
import org.apache.spark.sql.pulsar.IncompatibleSchemaException;
import org.apache.spark.sql.pulsar.IncompatibleSchemaException$;
import org.apache.spark.sql.pulsar.PulsarOptions$;
import org.apache.spark.sql.pulsar.SchemaUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;

public final class SchemaUtils$ {
    public static SchemaUtils$ MODULE$;
    private Schema nullSchema;
    private final Seq<StructField> metaDataFields;
    private volatile boolean bitmap$0;

    static {
        new SchemaUtils$();
    }

    private Schema nullSchema$lzycompute() {
        SchemaUtils$ schemaUtils$ = this;
        synchronized (schemaUtils$) {
            if (!this.bitmap$0) {
                this.nullSchema = Schema.create(Schema.Type.NULL);
                this.bitmap$0 = true;
            }
        }
        return this.nullSchema;
    }

    private Schema nullSchema() {
        return !this.bitmap$0 ? this.nullSchema$lzycompute() : this.nullSchema;
    }

    public SchemaInfo emptySchemaInfo() {
        return SchemaInfo.builder().name("empty").type(SchemaType.NONE).schema(new byte[0]).build();
    }

    public org.apache.pulsar.client.api.Schema<?> getPSchema(SchemaInfo schemaInfo) {
        org.apache.pulsar.client.api.Schema<Boolean> schema;
        SchemaType schemaType = schemaInfo.getType();
        if (((Object)((Object)SchemaType.BOOLEAN)).equals((Object)schemaType)) {
            schema = BooleanSchema.of();
        } else if (((Object)((Object)SchemaType.INT8)).equals((Object)schemaType)) {
            schema = ByteSchema.of();
        } else if (((Object)((Object)SchemaType.INT16)).equals((Object)schemaType)) {
            schema = ShortSchema.of();
        } else if (((Object)((Object)SchemaType.INT32)).equals((Object)schemaType)) {
            schema = IntSchema.of();
        } else if (((Object)((Object)SchemaType.INT64)).equals((Object)schemaType)) {
            schema = LongSchema.of();
        } else if (((Object)((Object)SchemaType.STRING)).equals((Object)schemaType)) {
            schema = org.apache.pulsar.client.api.Schema.STRING;
        } else if (((Object)((Object)SchemaType.FLOAT)).equals((Object)schemaType)) {
            schema = FloatSchema.of();
        } else if (((Object)((Object)SchemaType.DOUBLE)).equals((Object)schemaType)) {
            schema = DoubleSchema.of();
        } else if (((Object)((Object)SchemaType.BYTES)).equals((Object)schemaType)) {
            schema = BytesSchema.of();
        } else if (((Object)((Object)SchemaType.DATE)).equals((Object)schemaType)) {
            schema = DateSchema.of();
        } else if (((Object)((Object)SchemaType.TIME)).equals((Object)schemaType)) {
            schema = TimeSchema.of();
        } else if (((Object)((Object)SchemaType.TIMESTAMP)).equals((Object)schemaType)) {
            schema = TimestampSchema.of();
        } else if (((Object)((Object)SchemaType.NONE)).equals((Object)schemaType)) {
            schema = BytesSchema.of();
        } else {
            boolean bl = ((Object)((Object)SchemaType.AVRO)).equals((Object)schemaType) ? true : ((Object)((Object)SchemaType.JSON)).equals((Object)schemaType);
            if (bl) {
                schema = GenericSchemaImpl.of(schemaInfo);
            } else {
                throw new IllegalArgumentException(new StringBuilder(74).append("Retrieve schema instance from schema info for type '").append((Object)schemaInfo.getType()).append("' is not supported yet").toString());
            }
        }
        return schema;
    }

    public StructType pulsarSourceSchema(SchemaInfo si) {
        ListBuffer listBuffer;
        ListBuffer mainSchema = (ListBuffer)ListBuffer$.MODULE$.empty();
        SchemaUtils.TypeNullable typeNullable = this.si2SqlType(si);
        DataType dataType = typeNullable.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            listBuffer = mainSchema.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())));
        } else {
            listBuffer = mainSchema.$plus$eq((Object)new StructField("value", dataType, typeNullable.nullable(), StructField$.MODULE$.apply$default$4()));
        }
        mainSchema.$plus$plus$eq(this.metaDataFields());
        return StructType$.MODULE$.apply((Seq)mainSchema);
    }

    public SchemaUtils.TypeNullable si2SqlType(SchemaInfo si) {
        SchemaUtils.TypeNullable typeNullable;
        SchemaType schemaType = si.getType();
        if (((Object)((Object)SchemaType.NONE)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.BOOLEAN)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)BooleanType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.BYTES)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.DATE)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)DateType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.STRING)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.TIMESTAMP)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)TimestampType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.INT8)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)ByteType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.DOUBLE)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.FLOAT)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)FloatType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.INT32)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)IntegerType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.INT64)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
        } else if (((Object)((Object)SchemaType.INT16)).equals((Object)schemaType)) {
            typeNullable = new SchemaUtils.TypeNullable((DataType)ShortType$.MODULE$, false);
        } else {
            boolean bl = ((Object)((Object)SchemaType.AVRO)).equals((Object)schemaType) ? true : ((Object)((Object)SchemaType.JSON)).equals((Object)schemaType);
            if (bl) {
                Schema avroSchema = new Schema.Parser().parse(new String(si.getSchema(), StandardCharsets.UTF_8));
                typeNullable = this.avro2SqlType(avroSchema, (Set<String>)Predef$.MODULE$.Set().empty());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(29).append("We do not support ").append((Object)schemaType).append(" currently.").toString());
            }
        }
        return typeNullable;
    }

    /*
     * Unable to fully structure code
     */
    public SchemaUtils.TypeNullable avro2SqlType(Schema avroSchema, Set<String> existingRecordNames) {
        block20: {
            block21: {
                block22: {
                    block24: {
                        block23: {
                            while (true) {
                                if (Schema.Type.INT.equals((Object)(var11_5 = avroSchema.getType()))) {
                                    var12_7 = avroSchema.getLogicalType();
                                    var10_8 = var12_7 instanceof LogicalTypes.Date != false ? new SchemaUtils.TypeNullable((DataType)DateType$.MODULE$, false) : new SchemaUtils.TypeNullable((DataType)IntegerType$.MODULE$, false);
                                    var4_9 = var10_8;
                                    break block20;
                                }
                                if (Schema.Type.STRING.equals((Object)var11_5)) {
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
                                    break block20;
                                }
                                if (Schema.Type.BOOLEAN.equals((Object)var11_5)) {
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)BooleanType$.MODULE$, false);
                                    break block20;
                                }
                                var9_3 = Schema.Type.BYTES.equals((Object)var11_5) != false ? true : Schema.Type.FIXED.equals((Object)var11_5) != false;
                                if (var9_3) {
                                    var13_10 = avroSchema.getLogicalType();
                                    if (var13_10 instanceof LogicalTypes.Decimal) {
                                        var14_11 = (LogicalTypes.Decimal)var13_10;
                                        var8_12 = new SchemaUtils.TypeNullable((DataType)new DecimalType(var14_11.getPrecision(), var14_11.getScale()), false);
                                    } else {
                                        var8_12 = new SchemaUtils.TypeNullable((DataType)BinaryType$.MODULE$, false);
                                    }
                                    var4_9 = var8_12;
                                    break block20;
                                }
                                if (Schema.Type.DOUBLE.equals((Object)var11_5)) {
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
                                    break block20;
                                }
                                if (Schema.Type.FLOAT.equals((Object)var11_5)) {
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)FloatType$.MODULE$, false);
                                    break block20;
                                }
                                if (Schema.Type.LONG.equals((Object)var11_5)) {
                                    var15_13 = avroSchema.getLogicalType();
                                    var7_14 = var15_13 instanceof LogicalTypes.TimestampMillis != false ? true : var15_13 instanceof LogicalTypes.TimestampMicros != false;
                                    var6_15 = var7_14 != false ? new SchemaUtils.TypeNullable((DataType)TimestampType$.MODULE$, false) : new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
                                    var4_9 = var6_15;
                                    break block20;
                                }
                                if (Schema.Type.ENUM.equals((Object)var11_5)) {
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)StringType$.MODULE$, false);
                                    break block20;
                                }
                                if (Schema.Type.RECORD.equals((Object)var11_5)) {
                                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                                        throw new IncompatibleSchemaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(117).append("\n            |Found recursive reference in Avro schema, which can not be processed by Spark:\n            |").append(avroSchema.toString(true)).append("\n          ").toString())).stripMargin(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                                    }
                                    newRecordNames = (Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                                    fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$avro2SqlType$1(scala.collection.immutable.Set org.apache.pulsar.shade.org.apache.avro.Schema$Field ), (Lorg/apache/pulsar/shade/org/apache/avro/Schema$Field;)Lorg/apache/spark/sql/types/StructField;)((Set)newRecordNames), Buffer$.MODULE$.canBuildFrom());
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)StructType$.MODULE$.apply((Seq)fields), false);
                                    break block20;
                                }
                                if (Schema.Type.ARRAY.equals((Object)var11_5)) {
                                    typeNullable = this.avro2SqlType(avroSchema.getElementType(), existingRecordNames);
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)new ArrayType(typeNullable.dataType(), typeNullable.nullable()), false);
                                    break block20;
                                }
                                if (Schema.Type.MAP.equals((Object)var11_5)) {
                                    typeNullable = this.avro2SqlType(avroSchema.getValueType(), existingRecordNames);
                                    var4_9 = new SchemaUtils.TypeNullable((DataType)new MapType((DataType)StringType$.MODULE$, typeNullable.dataType(), typeNullable.nullable()), false);
                                    break block20;
                                }
                                if (!Schema.Type.UNION.equals((Object)var11_5)) break block21;
                                if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$avro2SqlType$2$adapted(org.apache.pulsar.shade.org.apache.avro.Schema ), (Lorg/apache/pulsar/shade/org/apache/avro/Schema;)Ljava/lang/Object;)())) {
                                    remainingUnionTypes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$avro2SqlType$3$adapted(org.apache.pulsar.shade.org.apache.avro.Schema ), (Lorg/apache/pulsar/shade/org/apache/avro/Schema;)Ljava/lang/Object;)());
                                    if (remainingUnionTypes.size() == 1) {
                                        qual$1 = this.avro2SqlType((Schema)remainingUnionTypes.head(), existingRecordNames);
                                        x$1 = true;
                                        x$2 = qual$1.copy$default$1();
                                        v0 = qual$1.copy(x$2, x$1);
                                    } else {
                                        qual$2 = this.avro2SqlType(Schema.createUnion((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(remainingUnionTypes).asJava()), existingRecordNames);
                                        x$3 = true;
                                        x$4 = qual$2.copy$default$1();
                                        v0 = qual$2.copy(x$4, x$3);
                                    }
                                    break block22;
                                }
                                var27_4 = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$avro2SqlType$4(org.apache.pulsar.shade.org.apache.avro.Schema ), (Lorg/apache/pulsar/shade/org/apache/avro/Schema;)Lorg/apache/pulsar/shade/org/apache/avro/Schema$Type;)(), Buffer$.MODULE$.canBuildFrom());
                                var28_6 = Seq$.MODULE$.unapplySeq((Seq)var27_4);
                                if (var28_6.isEmpty() || var28_6.get() == null || ((SeqLike)var28_6.get()).lengthCompare(1) != 0) break;
                                avroSchema = avroSchema.getTypes().get(0);
                            }
                            var29_27 = Seq$.MODULE$.unapplySeq((Seq)var27_4);
                            if (var29_27.isEmpty() || var29_27.get() == null || ((SeqLike)var29_27.get()).lengthCompare(2) != 0) break block23;
                            t1 = (Schema.Type)((SeqLike)var29_27.get()).apply(0);
                            t2 = (Schema.Type)((SeqLike)var29_27.get()).apply(1);
                            v1 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                            var32_30 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                            if (v1 != null ? v1.equals(var32_30) == false : var32_30 != null) break block23;
                            var5_31 = new SchemaUtils.TypeNullable((DataType)LongType$.MODULE$, false);
                            break block24;
                        }
                        if ((var33_32 = Seq$.MODULE$.unapplySeq((Seq)var27_4)).isEmpty() || var33_32.get() == null || ((SeqLike)var33_32.get()).lengthCompare(2) != 0) ** GOTO lbl-1000
                        t1 = (Schema.Type)((SeqLike)var33_32.get()).apply(0);
                        t2 = (Schema.Type)((SeqLike)var33_32.get()).apply(1);
                        v2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                        var36_35 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                        if (!(v2 != null ? v2.equals(var36_35) == false : var36_35 != null)) {
                            var5_31 = new SchemaUtils.TypeNullable((DataType)DoubleType$.MODULE$, false);
                        } else lbl-1000:
                        // 2 sources

                        {
                            fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$avro2SqlType$5(scala.collection.immutable.Set scala.Tuple2 ), (Lscala/Tuple2;)Lorg/apache/spark/sql/types/StructField;)(existingRecordNames), Buffer$.MODULE$.canBuildFrom());
                            var5_31 = new SchemaUtils.TypeNullable((DataType)StructType$.MODULE$.apply((Seq)fields), false);
                        }
                    }
                    v0 = var5_31;
                }
                var4_9 = v0;
                break block20;
            }
            throw new IncompatibleSchemaException(new StringBuilder(17).append("Unsupported type ").append((Object)var11_5).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return var4_9;
    }

    public GenericSchema<GenericRecord> ASchema2PSchema(Schema aschema) {
        byte[] schema = aschema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfoImpl si = SchemaInfoImpl.builder().name("Avro").schema(schema).type(SchemaType.AVRO).build();
        return org.apache.pulsar.client.api.Schema.generic(si);
    }

    public org.apache.pulsar.client.api.Schema<?> sqlType2PSchema(DataType catalystType, boolean nullable) {
        org.apache.pulsar.client.api.Schema<Boolean> schema;
        DataType dataType = catalystType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            schema = BooleanSchema.of();
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            schema = BytesSchema.of();
        } else if (DateType$.MODULE$.equals(dataType)) {
            schema = DateSchema.of();
        } else if (StringType$.MODULE$.equals(dataType)) {
            schema = org.apache.pulsar.client.api.Schema.STRING;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            schema = TimestampSchema.of();
        } else if (ByteType$.MODULE$.equals(dataType)) {
            schema = ByteSchema.of();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            schema = DoubleSchema.of();
        } else if (FloatType$.MODULE$.equals(dataType)) {
            schema = FloatSchema.of();
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            schema = IntSchema.of();
        } else if (LongType$.MODULE$.equals(dataType)) {
            schema = LongSchema.of();
        } else if (ShortType$.MODULE$.equals(dataType)) {
            schema = ShortSchema.of();
        } else if (dataType instanceof StructType) {
            schema = this.ASchema2PSchema(this.sqlType2ASchema(catalystType, this.sqlType2ASchema$default$2(), this.sqlType2ASchema$default$3(), this.sqlType2ASchema$default$4()));
        } else {
            throw new RuntimeException(new StringBuilder(21).append(catalystType).append(" is not supported yet").toString());
        }
        return schema;
    }

    public boolean sqlType2PSchema$default$2() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Schema sqlType2ASchema(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block5: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block4: {
                                                        builder = SchemaBuilder.builder();
                                                        var10_6 = catalystType;
                                                        if (!BooleanType$.MODULE$.equals(var10_6)) break block4;
                                                        var5_7 = (Schema)builder.booleanType();
                                                        break block5;
                                                    }
                                                    var7_8 = ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false);
                                                    if (!var7_8) break block6;
                                                    var5_7 = (Schema)builder.intType();
                                                    break block5;
                                                }
                                                if (!LongType$.MODULE$.equals(var10_6)) break block7;
                                                var5_7 = (Schema)builder.longType();
                                                break block5;
                                            }
                                            if (!DateType$.MODULE$.equals(var10_6)) break block8;
                                            var5_7 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                            break block5;
                                        }
                                        if (!TimestampType$.MODULE$.equals(var10_6)) break block9;
                                        var5_7 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                        break block5;
                                    }
                                    if (!FloatType$.MODULE$.equals(var10_6)) break block10;
                                    var5_7 = (Schema)builder.floatType();
                                    break block5;
                                }
                                if (!DoubleType$.MODULE$.equals(var10_6)) break block11;
                                var5_7 = (Schema)builder.doubleType();
                                break block5;
                            }
                            if (!StringType$.MODULE$.equals(var10_6)) break block12;
                            var5_7 = (Schema)builder.stringType();
                            break block5;
                        }
                        if (!BinaryType$.MODULE$.equals(var10_6)) break block13;
                        var5_7 = (Schema)builder.bytesType();
                        break block5;
                    }
                    if (!(var10_6 instanceof DecimalType)) break block14;
                    var11_9 = (DecimalType)var10_6;
                    avroType = LogicalTypes.decimal(var11_9.precision(), var11_9.scale());
                    fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var11_9.precision()];
                    var15_12 = nameSpace;
                    var6_13 = "".equals(var15_12) != false ? new StringBuilder(6).append(recordName).append(".fixed").toString() : new StringBuilder(7).append(nameSpace).append(".").append(recordName).append(".fixed").toString();
                    name = var6_13;
                    var5_7 = avroType.addToSchema(SchemaBuilder.fixed(name).size(fixedSize));
                    break block5;
                }
                if (!(var10_6 instanceof ArrayType)) break block15;
                var16_15 = (ArrayType)var10_6;
                et = var16_15.elementType();
                containsNull = var16_15.containsNull();
                var5_7 = (Schema)builder.array().items(this.sqlType2ASchema(et, containsNull, recordName, nameSpace));
                break block5;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var19_18 = (MapType)var10_6;
            var20_19 = var19_18.keyType();
            vt = var19_18.valueType();
            valueContainsNull = var19_18.valueContainsNull();
            if (StringType$.MODULE$.equals(var20_19)) {
                var5_7 = (Schema)builder.map().values(this.sqlType2ASchema(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var23_22 = (StructType)var10_6;
                v0 = nameSpace;
                var25_23 = "";
                childNameSpace = (v0 == null ? var25_23 != null : v0.equals(var25_23) == false) ? new StringBuilder(1).append(nameSpace).append(".").append(recordName).toString() : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var23_22.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$sqlType2ASchema$1(java.lang.String org.apache.pulsar.shade.org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/pulsar/shade/org/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, fieldsAssembler));
                var5_7 = (Schema)fieldsAssembler.endRecord();
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(var10_6).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = var5_7;
        return nullable != false ? Schema.createUnion(new Schema[]{schema, this.nullSchema()}) : schema;
    }

    public boolean sqlType2ASchema$default$2() {
        return false;
    }

    public String sqlType2ASchema$default$3() {
        return "topLevelRecord";
    }

    public String sqlType2ASchema$default$4() {
        return "";
    }

    public Seq<StructField> metaDataFields() {
        return this.metaDataFields;
    }

    public static final /* synthetic */ StructField $anonfun$avro2SqlType$1(Set newRecordNames$1, Schema.Field f) {
        SchemaUtils.TypeNullable typeNullable = MODULE$.avro2SqlType(f.schema(), (Set<String>)newRecordNames$1);
        return new StructField(f.name(), typeNullable.dataType(), typeNullable.nullable(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$avro2SqlType$2(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$avro2SqlType$3(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
    }

    public static final /* synthetic */ Schema.Type $anonfun$avro2SqlType$4(Schema x$3) {
        return x$3.getType();
    }

    public static final /* synthetic */ StructField $anonfun$avro2SqlType$5(Set existingRecordNames$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Schema s2 = (Schema)tuple2._1();
        int i = tuple2._2$mcI$sp();
        SchemaUtils.TypeNullable TypeNullable2 = MODULE$.avro2SqlType(s2, (Set<String>)existingRecordNames$1);
        StructField structField = new StructField(new StringBuilder(6).append("member").append(i).toString(), TypeNullable2.dataType(), true, StructField$.MODULE$.apply$default$4());
        return structField;
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$sqlType2ASchema$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.sqlType2ASchema(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.metaDataFields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(PulsarOptions$.MODULE$.KeyAttributeName(), (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(PulsarOptions$.MODULE$.TopicAttributeName(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(PulsarOptions$.MODULE$.MessageIdName(), (DataType)BinaryType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(PulsarOptions$.MODULE$.PublishTimeName(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(PulsarOptions$.MODULE$.EventTimeName(), (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField(PulsarOptions$.MODULE$.MessagePropertiesName(), (DataType)new MapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, true), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
    }

    public static final /* synthetic */ Object $anonfun$avro2SqlType$2$adapted(Schema x$1) {
        return BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$avro2SqlType$2(x$1));
    }

    public static final /* synthetic */ Object $anonfun$avro2SqlType$3$adapted(Schema x$2) {
        return BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$avro2SqlType$3(x$2));
    }
}

