/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicSubscription;

public class TopicSubscriptionSerializer
extends TypeSerializer<TopicSubscription> {
    public static final TopicSubscriptionSerializer INSTANCE = new TopicSubscriptionSerializer();

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<TopicSubscription> duplicate() {
        return this;
    }

    public TopicSubscription createInstance() {
        return new TopicSubscription();
    }

    public TopicSubscription copy(TopicSubscription from) {
        return TopicSubscription.builder().topic(from.getTopic()).subscriptionName(from.getSubscriptionName()).range(from.getRange()).build();
    }

    public TopicSubscription copy(TopicSubscription from, TopicSubscription reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(TopicSubscription record, DataOutputView target) throws IOException {
        byte[] bytes = record.getTopic().getBytes();
        target.writeInt(bytes.length);
        target.write(bytes);
        byte[] range = this.toBytes(record.getRange());
        target.writeInt(range.length);
        target.write(range);
        String subscriptionName = record.getSubscriptionName();
        if (subscriptionName == null) {
            target.writeInt(0);
            return;
        }
        byte[] subscriptionNameBytes = subscriptionName.getBytes();
        target.writeInt(subscriptionNameBytes.length);
        target.write(subscriptionNameBytes);
    }

    /*
     * Exception decompiling
     */
    private byte[] toBytes(SerializableRange range) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private SerializableRange toObject(byte[] serialized) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TopicSubscription deserialize(DataInputView source) throws IOException {
        TopicSubscription.TopicSubscriptionBuilder builder = TopicSubscription.builder();
        int length = source.readInt();
        byte[] serialized = new byte[length];
        source.read(serialized);
        builder.topic(new String(serialized));
        length = source.readInt();
        serialized = new byte[length];
        source.read(serialized);
        builder.range(this.toObject(serialized));
        length = source.readInt();
        if (length != 0) {
            serialized = new byte[length];
            source.read(serialized);
            builder.subscriptionName(new String(serialized));
        }
        return builder.build();
    }

    public TopicSubscription deserialize(TopicSubscription reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public TypeSerializerSnapshot<TopicSubscription> snapshotConfiguration() {
        return new TopicSubscriptionSerializerSnapshot();
    }

    public static final class TopicSubscriptionSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<TopicSubscription> {
        public TopicSubscriptionSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

