/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.subscription;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.BrokerPartition;
import org.apache.flink.connector.pulsar.source.SplitDivisionStrategy;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.connector.pulsar.source.subscription.AbstractPulsarSubscriber;
import org.apache.flink.connector.pulsar.source.util.AsyncUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.api.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicListSubscriber
extends AbstractPulsarSubscriber {
    private static final Logger log = LoggerFactory.getLogger(TopicListSubscriber.class);
    private static final long serialVersionUID = -6917603843104947866L;
    private final SplitDivisionStrategy splitDivisionStrategy;
    private final List<String> topics;

    public TopicListSubscriber(SplitDivisionStrategy splitDivisionStrategy, String ... topics) {
        this.splitDivisionStrategy = splitDivisionStrategy;
        Preconditions.checkArgument((topics.length > 0 ? 1 : 0) != 0, (Object)"At least one topic needs to be specified");
        this.topics = new ArrayList<String>(Arrays.asList(topics));
    }

    @Override
    public Collection<AbstractPartition> getCurrentPartitions(PulsarAdmin pulsarAdmin) throws PulsarAdminException, InterruptedException, IOException {
        ArrayList<AbstractPartition> partitions = new ArrayList<AbstractPartition>();
        try {
            AsyncUtils.parallelAsync(this.topics, arg_0 -> ((Topics)pulsarAdmin.topics()).getPartitionedTopicMetadataAsync(arg_0), (topic, exception) -> exception.getStatusCode() == 404, (topic, topicMetadata) -> {
                log.info("in getCurrentPartitions");
                int numPartitions = topicMetadata.partitions;
                Collection<Range> ranges = this.splitDivisionStrategy.getRanges((String)topic, pulsarAdmin, (SplitEnumeratorContext<PulsarPartitionSplit>)this.context);
                if (numPartitions == 0) {
                    for (Range range : ranges) {
                        partitions.add(new BrokerPartition(new TopicRange((String)topic, range)));
                    }
                } else {
                    for (int i = 0; i < numPartitions; ++i) {
                        String fullName = topic + "-partition-" + i;
                        for (Range range : ranges) {
                            partitions.add(new BrokerPartition(new TopicRange(fullName, range)));
                        }
                    }
                }
            }, PulsarAdminException.class);
        }
        catch (TimeoutException e) {
            throw new IOException("Cannot retrieve topic metadata: " + e.getMessage());
        }
        return partitions;
    }
}

