/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader;

import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;

public class ParsedMessage<T> {
    private final T payload;
    private final MessageId messageId;
    private final long timestamp;

    public ParsedMessage(T payload, MessageId messageId, long timestamp) {
        this.payload = payload;
        this.messageId = messageId;
        this.timestamp = timestamp;
    }

    public T getPayload() {
        return this.payload;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParsedMessage that = (ParsedMessage)o;
        return this.timestamp == that.timestamp && this.payload.equals(that.payload) && this.messageId.equals(that.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.messageId, this.timestamp);
    }

    public String toString() {
        return "ParsedMessage{payload=" + this.payload + ", messageId=" + this.messageId + ", timestamp=" + this.timestamp + '}';
    }
}

