/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.offset;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.StartOffsetInitializer;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;

public class TimestampStartOffsetInitializer
implements StartOffsetInitializer {
    private static final long serialVersionUID = 2932230571773627233L;
    private final long startingTimestamp;

    public TimestampStartOffsetInitializer(long startingTimestamp) {
        this.startingTimestamp = startingTimestamp;
    }

    @Override
    public void initializeAfterCreation(AbstractPartition partition, Consumer<?> consumer) throws PulsarClientException {
        consumer.seek(this.startingTimestamp);
    }

    @Override
    public Optional<String> verifyOffset(AbstractPartition partition, Supplier<Optional<MessageId>> lastMessageIdFetcher, Supplier<Optional<Message<byte[]>>> firstMessageFetcher) {
        return firstMessageFetcher.get().isPresent() ? Optional.empty() : Optional.of(String.format("No data found after timestamp %s", this.startingTimestamp));
    }
}

