/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.offset;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.StartOffsetInitializer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;

public class RollbackStartOffsetInitializer
implements StartOffsetInitializer {
    private static final long serialVersionUID = 2932230571773627233L;
    private final long rollbackTimeInS;

    public RollbackStartOffsetInitializer(long rollbackTimeInS) {
        this.rollbackTimeInS = rollbackTimeInS;
    }

    @Override
    public void initializeBeforeCreation(AbstractPartition partition, StartOffsetInitializer.CreationConfiguration creationConfiguration) {
        creationConfiguration.setRollbackInS(this.rollbackTimeInS);
    }

    @Override
    public Optional<String> verifyOffset(AbstractPartition partition, Supplier<Optional<MessageId>> lastMessageIdFetcher, Supplier<Optional<Message<byte[]>>> firstMessageFetcher) {
        return firstMessageFetcher.get().isPresent() ? Optional.empty() : Optional.of(String.format("No data found %s secs ago", this.rollbackTimeInS));
    }
}

