/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.util;

import org.apache.flink.shaded.guava30.com.google.common.hash.Hashing;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.TopicMetadata;

public class KeyHashMessageRouterImpl
implements MessageRouter {
    public static final KeyHashMessageRouterImpl INSTANCE = new KeyHashMessageRouterImpl();

    private KeyHashMessageRouterImpl() {
    }

    public int choosePartition(Message<?> msg, TopicMetadata metadata) {
        int hashing = Hashing.murmur3_32().hashBytes(msg.getKeyBytes()).asInt();
        return Math.abs(hashing) % metadata.numPartitions();
    }
}

