/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.table.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.flink.streaming.connectors.pulsar.config.StartupMode;
import org.apache.flink.streaming.connectors.pulsar.table.descriptors.PulsarValidator;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;

public class Pulsar
implements Descriptor {
    private String topic;
    private String serviceUrl;
    private String adminUrl;
    private StartupMode startupMode;
    private boolean useExtendField;
    private Map<String, MessageId> specificOffsets;
    private String externalSubscriptionName;
    private Map<String, String> pulsarProperties;
    private String sinkExtractorType;
    private String subscriptionPosition;

    public Pulsar urls(String serviceUrl, String adminUrl) {
        Preconditions.checkNotNull((Object)serviceUrl);
        Preconditions.checkNotNull((Object)adminUrl);
        this.serviceUrl = serviceUrl;
        this.adminUrl = adminUrl;
        return this;
    }

    public Pulsar topic(String topic) {
        Preconditions.checkNotNull((Object)topic);
        this.topic = topic;
        return this;
    }

    public Pulsar properties(Properties properties) {
        Preconditions.checkNotNull((Object)properties);
        if (this.pulsarProperties == null) {
            this.pulsarProperties = new HashMap<String, String>();
        }
        this.pulsarProperties.clear();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.pulsarProperties.put(String.valueOf(k), String.valueOf(v))));
        return this;
    }

    public Pulsar useExtendField(boolean useExtendField) {
        this.useExtendField = useExtendField;
        return this;
    }

    public Pulsar property(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        if (this.pulsarProperties == null) {
            this.pulsarProperties = new HashMap<String, String>();
        }
        this.pulsarProperties.put(key, value);
        return this;
    }

    public Pulsar startFromEarliest() {
        this.startupMode = StartupMode.EARLIEST;
        this.specificOffsets = null;
        return this;
    }

    public Pulsar startFromLatest() {
        this.startupMode = StartupMode.LATEST;
        this.specificOffsets = null;
        return this;
    }

    public Pulsar startFromSpecificOffsets(Map<String, MessageId> specificOffsets) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        this.specificOffsets = (Map)Preconditions.checkNotNull(specificOffsets);
        return this;
    }

    public Pulsar startFromSpecificOffset(String partition, MessageId specificOffset) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        if (this.specificOffsets == null) {
            this.specificOffsets = new HashMap<String, MessageId>();
        }
        this.specificOffsets.put(partition, specificOffset);
        return this;
    }

    public Pulsar startFromExternalSubscription(String externalSubscriptionName) {
        this.startupMode = StartupMode.EXTERNAL_SUBSCRIPTION;
        this.externalSubscriptionName = externalSubscriptionName;
        return this;
    }

    public Pulsar startFromExternalSubscription(String externalSubscriptionName, String subscriptionPosition) {
        this.startupMode = StartupMode.EXTERNAL_SUBSCRIPTION;
        this.subscriptionPosition = subscriptionPosition;
        return this;
    }

    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        if (this.serviceUrl != null) {
            properties.putString("connector.service-url", this.serviceUrl);
        }
        if (this.adminUrl != null) {
            properties.putString("connector.admin-url", this.adminUrl);
        }
        if (this.topic != null) {
            properties.putString("connector.topic", this.topic);
        }
        if (this.startupMode != null) {
            properties.putString("connector.startup-mode", PulsarValidator.normalizeStartupMode(this.startupMode));
        }
        if (this.externalSubscriptionName != null) {
            properties.putString("connector.sub-name", this.externalSubscriptionName);
        }
        if (this.subscriptionPosition != null) {
            properties.putString("connector.sub-default-offset", this.subscriptionPosition);
        }
        if (this.specificOffsets != null) {
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (Map.Entry<String, MessageId> entry : this.specificOffsets.entrySet()) {
                values.add(Arrays.asList(entry.getKey(), new String(entry.getValue().toByteArray())));
            }
            properties.putIndexedFixedProperties("connector.specific-offsets", Arrays.asList("partition", "offset"), values);
        }
        if (this.pulsarProperties != null) {
            properties.putIndexedFixedProperties("connector.properties", Arrays.asList("key", "value"), this.pulsarProperties.entrySet().stream().map(e -> Arrays.asList((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
        }
        properties.putBoolean("connector.use-extend-field", this.useExtendField);
        return properties.asMap();
    }
}

