/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava30.com.google.common.base.CaseFormat;
import org.apache.flink.streaming.connectors.pulsar.config.StartupMode;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarSinkSemantic;
import org.apache.flink.streaming.connectors.pulsar.util.KeyHashMessageRouterImpl;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarTableOptions {
    private static final Logger log = LoggerFactory.getLogger(PulsarTableOptions.class);
    public static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)("key." + FactoryUtil.FORMAT.key())).stringType().noDefaultValue().withDescription("Defines the format identifier for encoding key data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<String> VALUE_FORMAT = ConfigOptions.key((String)("value." + FactoryUtil.FORMAT.key())).stringType().noDefaultValue().withFallbackKeys(new String[]{FactoryUtil.FORMAT.key()}).withDescription("Defines the format identifier for encoding value data. The identifier is used to discover a suitable format factory.");
    public static final ConfigOption<List<String>> KEY_FIELDS = ConfigOptions.key((String)"key.fields").stringType().asList().defaultValues((Object[])new String[0]).withDescription("Defines an explicit list of physical columns from the table schema that configure the data type for the key format. By default, this list is empty and thus a key is undefined.");
    public static final ConfigOption<ValueFieldsStrategy> VALUE_FIELDS_INCLUDE = ConfigOptions.key((String)"value.fields-include").enumType(ValueFieldsStrategy.class).defaultValue((Object)ValueFieldsStrategy.ALL).withDescription("Defines a strategy how to deal with key columns in the data type of the value format. By default, '" + (Object)((Object)ValueFieldsStrategy.ALL) + "' physical columns of the table schema will be included in the value format which means that key columns appear in the data type for both the key and value format.");
    public static final ConfigOption<String> KEY_FIELDS_PREFIX = ConfigOptions.key((String)"key.fields-prefix").stringType().noDefaultValue().withDescription("Defines a custom prefix for all fields of the key format to avoid name clashes with fields of the value format. By default, the prefix is empty. If a custom prefix is defined, both the table schema and '" + KEY_FIELDS.key() + "' will work with prefixed names. When constructing the data type of the key format, the prefix will be removed and the non-prefixed names will be used within the key format. Please note that this option requires that '" + VALUE_FIELDS_INCLUDE.key() + "' must be '" + (Object)((Object)ValueFieldsStrategy.EXCEPT_KEY) + "'.");
    public static final ConfigOption<String> SERVICE_URL = ConfigOptions.key((String)"service-url").stringType().noDefaultValue().withDescription("Required pulsar server connection string");
    public static final ConfigOption<String> ADMIN_URL = ConfigOptions.key((String)"admin-url").stringType().noDefaultValue().withDescription("Required pulsar admin connection string");
    public static final ConfigOption<Boolean> GENERIC = ConfigOptions.key((String)"generic").booleanType().defaultValue((Object)false).withDescription("Indicate if the table is a generic flink table");
    public static final ConfigOption<List<String>> TOPIC = ConfigOptions.key((String)"topic").stringType().asList().noDefaultValue().withDescription("Topic names from which the table is read. Either 'topic' or 'topic-pattern' must be set for source. Option 'topic' is required for sink.");
    public static final ConfigOption<String> TOPIC_PATTERN = ConfigOptions.key((String)"topic-pattern").stringType().noDefaultValue().withDescription("Optional topic pattern from which the table is read for source. Either 'topic' or 'topic-pattern' must be set.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"latest").withDescription("Optional startup mode for Pulsar consumer, valid enumerations are \"earliest\", \"latest\", \"external-subscription\",\nor \"specific-offsets\"");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSETS = ConfigOptions.key((String)"scan.startup.specific-offsets").stringType().noDefaultValue().withDescription("Optional offsets used in case of \"specific-offsets\" startup mode");
    public static final ConfigOption<String> SCAN_STARTUP_SUB_NAME = ConfigOptions.key((String)"scan.startup.sub-name").stringType().noDefaultValue().withDescription("Optional sub-name used in case of \"external-subscription\" startup mode");
    public static final ConfigOption<String> SCAN_STARTUP_SUB_START_OFFSET = ConfigOptions.key((String)"scan.startup.sub-start-offset").stringType().defaultValue((Object)"latest").withDescription("Optional sub-start-offset used in case of \"external-subscription\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    public static final ConfigOption<Long> PARTITION_DISCOVERY_INTERVAL_MILLIS = ConfigOptions.key((String)"partition.discovery.interval-millis").longType().noDefaultValue().withDescription("Optional discovery topic interval of \"interval-millis\" millis");
    public static final ConfigOption<String> SINK_MESSAGE_ROUTER = ConfigOptions.key((String)"sink.message-router").stringType().noDefaultValue().withDescription("Optional output MessageRouter \ninto pulsar's partitions valid enumerations are\n\"key-hash\": (each Flink partition ends up in at most one pulsar partition by key'hash, must set key for message),\n\"round-robin\": (a Flink partition is distributed to pulsar partitions round-robin, it's default messageRouter in pulsar)\n\"custom class name\": (use a custom MessageRouter subclass)");
    public static final ConfigOption<String> SINK_SEMANTIC = ConfigOptions.key((String)"sink.semantic").stringType().defaultValue((Object)"at-least-once").withDescription("Optional semantic when commit. Valid enumerationns are [\"at-least-once\", \"exactly-once\", \"none\"]");
    public static final ConfigOption<Map<String, String>> PROPERTIES = ConfigOptions.key((String)"properties").mapType().defaultValue(Collections.emptyMap()).withDescription("Optional pulsar config.");
    public static final String SCAN_STARTUP_MODE_VALUE_EARLIEST = "earliest";
    public static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest";
    public static final String SCAN_STARTUP_MODE_VALUE_EXTERNAL_SUBSCRIPTION = "external-subscription";
    public static final String SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS = "specific-offsets";
    public static final String SCAN_STARTUP_MODE_TIMESTAMP = "timestamp";
    private static final Set<String> SCAN_STARTUP_MODE_ENUMS = new HashSet<String>(Arrays.asList("earliest", "latest", "external-subscription", "specific-offsets", "timestamp"));
    public static final String SINK_MESSAGE_ROUTER_VALUE_KEY_HASH = "key-hash";
    public static final String SINK_MESSAGE_ROUTER_VALUE_ROUND_ROBIN = "round-robin";
    private static final Set<String> SINK_MESSAGE_ROUTER_ENUMS = new HashSet<String>(Arrays.asList("key-hash", "round-robin"));
    public static final String SINK_SEMANTIC_VALUE_EXACTLY_ONCE = "exactly-once";
    public static final String SINK_SEMANTIC_VALUE_AT_LEAST_ONCE = "at-least-once";
    public static final String SINK_SEMANTIC_VALUE_NONE = "none";
    private static final Set<String> SINK_SEMANTIC_ENUMS = new HashSet<String>(Arrays.asList("at-least-once", "exactly-once", "none"));
    public static final String PROPERTIES_PREFIX = "properties.";
    private static final String PARTITION = "partition";
    private static final String OFFSET = "offset";

    public static void validateTableSourceOptions(ReadableConfig tableOptions) {
        PulsarTableOptions.validateSourceTopic(tableOptions);
        PulsarTableOptions.validateScanStartupMode(tableOptions);
    }

    public static void validateSourceTopic(ReadableConfig tableOptions) {
        Optional topic = tableOptions.getOptional(TOPIC);
        Optional pattern = tableOptions.getOptional(TOPIC_PATTERN);
        if (topic.isPresent() && pattern.isPresent()) {
            throw new ValidationException("Option 'topic' and 'topic-pattern' shouldn't be set together.");
        }
        if (!topic.isPresent() && !pattern.isPresent()) {
            throw new ValidationException("Either 'topic' or 'topic-pattern' must be set.");
        }
    }

    private static void validateScanStartupMode(ReadableConfig tableOptions) {
        tableOptions.getOptional(SCAN_STARTUP_MODE).map(String::toLowerCase).ifPresent(mode -> {
            if (!SCAN_STARTUP_MODE_ENUMS.contains(mode)) {
                throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are %s, but was: %s", SCAN_STARTUP_MODE.key(), "[earliest, latest, specific-offsets, external-subscription]", mode));
            }
            if (mode.equals(SCAN_STARTUP_MODE_VALUE_EXTERNAL_SUBSCRIPTION) && !tableOptions.getOptional(SCAN_STARTUP_SUB_NAME).isPresent()) {
                throw new ValidationException(String.format("'%s' is required in '%s' startup mode but missing.", SCAN_STARTUP_SUB_NAME.key(), SCAN_STARTUP_SUB_NAME));
            }
            if (mode.equals(SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS)) {
                if (!tableOptions.getOptional(SCAN_STARTUP_SPECIFIC_OFFSETS).isPresent()) {
                    throw new ValidationException(String.format("'%s' is required in '%s' startup mode but missing.", SCAN_STARTUP_SPECIFIC_OFFSETS.key(), SCAN_STARTUP_MODE_VALUE_SPECIFIC_OFFSETS));
                }
                String specificOffsets = (String)tableOptions.get(SCAN_STARTUP_SPECIFIC_OFFSETS);
                PulsarTableOptions.parseSpecificOffsets(specificOffsets, SCAN_STARTUP_SPECIFIC_OFFSETS.key());
            }
        });
    }

    public static void validateTableSinkOptions(ReadableConfig tableOptions) {
        PulsarTableOptions.validateSinkTopic(tableOptions);
        PulsarTableOptions.validateSinkSemantic(tableOptions);
    }

    public static void validateSinkMessageRouter(ReadableConfig tableOptions) {
        tableOptions.getOptional(SINK_MESSAGE_ROUTER).ifPresent(router -> {
            if (!SINK_MESSAGE_ROUTER_ENUMS.contains(router.toLowerCase()) && router.isEmpty()) {
                throw new ValidationException(String.format("Option '%s' should be a non-empty string.", SINK_MESSAGE_ROUTER.key()));
            }
        });
    }

    public static void validateSinkTopic(ReadableConfig tableOptions) {
        String errorMessageTemp = "Flink Pulsar sink currently only supports single topic, but got %s: %s.";
        if (!PulsarTableOptions.isSingleTopic(tableOptions)) {
            if (tableOptions.getOptional(TOPIC_PATTERN).isPresent()) {
                throw new ValidationException(String.format(errorMessageTemp, "'topic-pattern'", tableOptions.get(TOPIC_PATTERN)));
            }
            throw new ValidationException(String.format(errorMessageTemp, "'topic'", tableOptions.get(TOPIC)));
        }
    }

    private static void validateSinkSemantic(ReadableConfig tableOptions) {
        tableOptions.getOptional(SINK_SEMANTIC).ifPresent(semantic -> {
            if (!SINK_SEMANTIC_ENUMS.contains(semantic)) {
                throw new ValidationException(String.format("Unsupported value '%s' for '%s'. Supported values are ['at-least-once', 'exactly-once', 'none'].", semantic, SINK_SEMANTIC.key()));
            }
        });
    }

    private static boolean isSingleTopic(ReadableConfig tableOptions) {
        return tableOptions.getOptional(TOPIC).map(t -> t.size() == 1).orElse(false);
    }

    public static PulsarSinkSemantic getSinkSemantic(ReadableConfig tableOptions) {
        switch ((String)tableOptions.get(SINK_SEMANTIC)) {
            case "exactly-once": {
                return PulsarSinkSemantic.EXACTLY_ONCE;
            }
            case "at-least-once": {
                return PulsarSinkSemantic.AT_LEAST_ONCE;
            }
            case "none": {
                return PulsarSinkSemantic.NONE;
            }
        }
        throw new TableException("Validator should have checked that");
    }

    public static Properties getPulsarProperties(Map<String, String> tableOptions) {
        Properties pulsarProperties = new Properties();
        if (PulsarTableOptions.hasPulsarClientProperties(tableOptions)) {
            tableOptions.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)tableOptions.get(key);
                String subKey = key.substring(PROPERTIES_PREFIX.length());
                if (subKey.startsWith("pulsar.")) {
                    subKey = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, subKey);
                }
                pulsarProperties.put(subKey, value);
            });
        }
        pulsarProperties.computeIfAbsent(PARTITION_DISCOVERY_INTERVAL_MILLIS.key(), (Function<? super Object, ?>)((Function<Object, Object>)tableOptions::get));
        return pulsarProperties;
    }

    public static Optional<MessageRouter> getMessageRouter(ReadableConfig tableOptions, ClassLoader classLoader) {
        return tableOptions.getOptional(SINK_MESSAGE_ROUTER).flatMap(partitioner -> {
            switch (partitioner) {
                case "key-hash": {
                    return Optional.of(KeyHashMessageRouterImpl.INSTANCE);
                }
                case "round-robin": {
                    return Optional.empty();
                }
            }
            return Optional.of(PulsarTableOptions.initializeMessageRouter(partitioner, classLoader));
        });
    }

    private static MessageRouter initializeMessageRouter(String name, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(name, true, classLoader);
            if (!MessageRouter.class.isAssignableFrom(clazz)) {
                throw new ValidationException(String.format("Sink messageRouter class '%s' should extend from the required class %s", name, MessageRouter.class.getName()));
            }
            MessageRouter messageRouter = (MessageRouter)InstantiationUtil.instantiate((String)name, MessageRouter.class, (ClassLoader)classLoader);
            return messageRouter;
        }
        catch (ClassNotFoundException | FlinkException e) {
            throw new ValidationException(String.format("Could not find and instantiate messageRouter class '%s'", name), e);
        }
    }

    private static boolean hasPulsarClientProperties(Map<String, String> tableOptions) {
        return tableOptions.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }

    public static StartupOptions getStartupOptions(ReadableConfig tableOptions) {
        StartupOptions options = new StartupOptions();
        HashMap<String, MessageId> specificOffsets = new HashMap<String, MessageId>();
        Optional modeString = tableOptions.getOptional(SCAN_STARTUP_MODE);
        if (!modeString.isPresent()) {
            options.startupMode = StartupMode.LATEST;
        } else {
            switch ((String)modeString.get()) {
                case "earliest": {
                    options.startupMode = StartupMode.EARLIEST;
                    break;
                }
                case "latest": {
                    options.startupMode = StartupMode.LATEST;
                    break;
                }
                case "specific-offsets": {
                    String specificOffsetsStrOpt = (String)tableOptions.get(SCAN_STARTUP_SPECIFIC_OFFSETS);
                    Map<Integer, String> offsetList = PulsarTableOptions.parseSpecificOffsets(specificOffsetsStrOpt, SCAN_STARTUP_SPECIFIC_OFFSETS.key());
                    offsetList.forEach((partition, offset) -> {
                        try {
                            MessageIdImpl messageId = PulsarTableOptions.parseMessageId(offset);
                            specificOffsets.put(partition.toString(), (MessageId)messageId);
                        }
                        catch (Exception e) {
                            log.error("Failed to decode message id from properties {}", (Object)ExceptionUtils.stringifyException((Throwable)e));
                            throw new IllegalStateException(e);
                        }
                    });
                    options.startupMode = StartupMode.SPECIFIC_OFFSETS;
                    options.specificOffsets = specificOffsets;
                    break;
                }
                case "external-subscription": {
                    options.externalSubscriptionName = (String)tableOptions.get(SCAN_STARTUP_SUB_NAME);
                    options.externalSubStartOffset = (String)tableOptions.get(SCAN_STARTUP_SUB_START_OFFSET);
                    options.startupMode = StartupMode.EXTERNAL_SUBSCRIPTION;
                    break;
                }
                case "timestamp": {
                    options.startupMode = StartupMode.TIMESTAMP;
                    options.startupTimestampMills = (Long)tableOptions.get(SCAN_STARTUP_TIMESTAMP_MILLIS);
                    break;
                }
                default: {
                    throw new TableException("Unsupported startup mode. Validator should have checked that.");
                }
            }
        }
        return options;
    }

    private static MessageIdImpl parseMessageId(String offset) {
        String[] split = offset.split(":");
        return new MessageIdImpl(Long.parseLong(split[0]), Long.parseLong(split[1]), Integer.parseInt(split[2]));
    }

    public static Map<Integer, String> parseSpecificOffsets(String specificOffsetsStr, String optionKey) {
        HashMap<Integer, String> offsetMap = new HashMap<Integer, String>();
        String[] pairs = specificOffsetsStr.split(";");
        String validationExceptionMessage = String.format("Invalid properties '%s' should follow the format messageId with partition'42:1012:0;44:1011:1', but is '%s'.", optionKey, specificOffsetsStr);
        if (pairs.length == 0) {
            throw new ValidationException(validationExceptionMessage);
        }
        for (String pair : pairs) {
            if (null == pair || pair.length() == 0) break;
            if (pair.contains(",")) {
                throw new ValidationException(validationExceptionMessage);
            }
            String[] kv = pair.split(":");
            if (kv.length != 3) {
                throw new ValidationException(validationExceptionMessage);
            }
            String partitionValue = kv[2];
            String offsetValue = pair;
            try {
                Integer partition = Integer.valueOf(partitionValue);
                offsetMap.put(partition, offsetValue);
            }
            catch (NumberFormatException e) {
                throw new ValidationException(validationExceptionMessage, (Throwable)e);
            }
        }
        return offsetMap;
    }

    public static int[] createKeyFormatProjection(ReadableConfig options, DataType physicalDataType) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot((LogicalType)physicalType, (LogicalTypeRoot)LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        Optional optionalKeyFormat = options.getOptional(KEY_FORMAT);
        Optional optionalKeyFields = options.getOptional(KEY_FIELDS);
        if (!optionalKeyFormat.isPresent() && optionalKeyFields.isPresent()) {
            throw new ValidationException(String.format("The option '%s' can only be declared if a key format is defined using '%s'.", KEY_FIELDS.key(), KEY_FORMAT.key()));
        }
        if (optionalKeyFormat.isPresent() && (!optionalKeyFields.isPresent() || ((List)optionalKeyFields.get()).size() == 0)) {
            throw new ValidationException(String.format("A key format '%s' requires the declaration of one or more of key fields using '%s'.", KEY_FORMAT.key(), KEY_FIELDS.key()));
        }
        if (!optionalKeyFormat.isPresent()) {
            return new int[0];
        }
        String keyPrefix = options.getOptional(KEY_FIELDS_PREFIX).orElse("");
        List keyFields = (List)optionalKeyFields.get();
        List physicalFields = LogicalTypeChecks.getFieldNames((LogicalType)physicalType);
        return keyFields.stream().mapToInt(keyField -> {
            int pos = physicalFields.indexOf(keyField);
            if (pos < 0) {
                throw new ValidationException(String.format("Could not find the field '%s' in the table schema for usage in the key format. A key field must be a regular, physical column. The following columns can be selected in the '%s' option:\n%s", keyField, KEY_FIELDS.key(), physicalFields));
            }
            if (!keyField.startsWith(keyPrefix)) {
                throw new ValidationException(String.format("All fields in '%s' must be prefixed with '%s' when option '%s' is set but field '%s' is not prefixed.", KEY_FIELDS.key(), keyPrefix, KEY_FIELDS_PREFIX.key(), keyField));
            }
            return pos;
        }).toArray();
    }

    public static int[] createValueFormatProjection(ReadableConfig options, DataType physicalDataType) {
        LogicalType physicalType = physicalDataType.getLogicalType();
        Preconditions.checkArgument((boolean)LogicalTypeChecks.hasRoot((LogicalType)physicalType, (LogicalTypeRoot)LogicalTypeRoot.ROW), (Object)"Row data type expected.");
        int physicalFieldCount = LogicalTypeChecks.getFieldCount((LogicalType)physicalType);
        IntStream physicalFields = IntStream.range(0, physicalFieldCount);
        String keyPrefix = options.getOptional(KEY_FIELDS_PREFIX).orElse("");
        ValueFieldsStrategy strategy = (ValueFieldsStrategy)((Object)options.get(VALUE_FIELDS_INCLUDE));
        if (strategy == ValueFieldsStrategy.ALL) {
            if (keyPrefix.length() > 0) {
                throw new ValidationException(String.format("A key prefix is not allowed when option '%s' is set to '%s'. Set it to '%s' instead to avoid field overlaps.", new Object[]{VALUE_FIELDS_INCLUDE.key(), ValueFieldsStrategy.ALL, ValueFieldsStrategy.EXCEPT_KEY}));
            }
            return physicalFields.toArray();
        }
        if (strategy == ValueFieldsStrategy.EXCEPT_KEY) {
            int[] keyProjection = PulsarTableOptions.createKeyFormatProjection(options, physicalDataType);
            return physicalFields.filter(pos -> IntStream.of(keyProjection).noneMatch(k -> k == pos)).toArray();
        }
        throw new TableException("Unknown value fields strategy:" + (Object)((Object)strategy));
    }

    private PulsarTableOptions() {
    }

    public static enum ValueFieldsStrategy {
        ALL,
        EXCEPT_KEY;

    }

    public static class StartupOptions {
        public StartupMode startupMode;
        public Map<String, MessageId> specificOffsets = new HashMap<String, MessageId>();
        public String externalSubscriptionName;
        public String externalSubStartOffset;
        public long startupTimestampMills;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartupOptions)) {
                return false;
            }
            StartupOptions other = (StartupOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.startupTimestampMills != other.startupTimestampMills) {
                return false;
            }
            StartupMode this$startupMode = this.startupMode;
            StartupMode other$startupMode = other.startupMode;
            if (this$startupMode == null ? other$startupMode != null : !((Object)((Object)this$startupMode)).equals((Object)other$startupMode)) {
                return false;
            }
            Map<String, MessageId> this$specificOffsets = this.specificOffsets;
            Map<String, MessageId> other$specificOffsets = other.specificOffsets;
            if (this$specificOffsets == null ? other$specificOffsets != null : !((Object)this$specificOffsets).equals(other$specificOffsets)) {
                return false;
            }
            String this$externalSubscriptionName = this.externalSubscriptionName;
            String other$externalSubscriptionName = other.externalSubscriptionName;
            if (this$externalSubscriptionName == null ? other$externalSubscriptionName != null : !this$externalSubscriptionName.equals(other$externalSubscriptionName)) {
                return false;
            }
            String this$externalSubStartOffset = this.externalSubStartOffset;
            String other$externalSubStartOffset = other.externalSubStartOffset;
            return !(this$externalSubStartOffset == null ? other$externalSubStartOffset != null : !this$externalSubStartOffset.equals(other$externalSubStartOffset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StartupOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startupTimestampMills = this.startupTimestampMills;
            result = result * 59 + (int)($startupTimestampMills >>> 32 ^ $startupTimestampMills);
            StartupMode $startupMode = this.startupMode;
            result = result * 59 + ($startupMode == null ? 43 : ((Object)((Object)$startupMode)).hashCode());
            Map<String, MessageId> $specificOffsets = this.specificOffsets;
            result = result * 59 + ($specificOffsets == null ? 43 : ((Object)$specificOffsets).hashCode());
            String $externalSubscriptionName = this.externalSubscriptionName;
            result = result * 59 + ($externalSubscriptionName == null ? 43 : $externalSubscriptionName.hashCode());
            String $externalSubStartOffset = this.externalSubStartOffset;
            result = result * 59 + ($externalSubStartOffset == null ? 43 : $externalSubStartOffset.hashCode());
            return result;
        }
    }
}

