/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.serialization;

import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.guava30.com.google.common.base.Preconditions;
import org.apache.flink.streaming.connectors.pulsar.serialization.PulsarContextAware;
import org.apache.flink.streaming.connectors.pulsar.serialization.PulsarDeserializationSchema;
import org.apache.flink.streaming.connectors.pulsar.serialization.PulsarSerializationSchema;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;

public class PulsarPrimitiveSchema<T>
implements PulsarSerializationSchema<T>,
PulsarDeserializationSchema<T>,
PulsarContextAware<T> {
    private static final Map<Class<?>, Schema<?>> pulsarPrimitives = new HashMap();
    private final Class<T> recordClazz;

    public PulsarPrimitiveSchema(Class<T> recordClazz) {
        Preconditions.checkArgument((boolean)pulsarPrimitives.containsKey(recordClazz), (Object)"Must be of Pulsar primitive types");
        this.recordClazz = recordClazz;
    }

    public static boolean isPulsarPrimitive(Class<?> key) {
        return pulsarPrimitives.containsKey(key);
    }

    @Override
    public void serialize(T element, TypedMessageBuilder<T> messageBuilder) {
        messageBuilder.value(element);
    }

    @Override
    public T deserialize(Message<T> message) throws IOException {
        return (T)message.getValue();
    }

    @Override
    public Optional<String> getTargetTopic(T element) {
        return Optional.empty();
    }

    @Override
    public Schema<T> getSchema() {
        return pulsarPrimitives.get(this.recordClazz);
    }

    public TypeInformation<T> getProducedType() {
        return TypeInformation.of(this.recordClazz);
    }

    @Override
    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    static {
        pulsarPrimitives.put(Boolean.class, (Schema<?>)BooleanSchema.of());
        pulsarPrimitives.put(Boolean.TYPE, (Schema<?>)BooleanSchema.of());
        pulsarPrimitives.put(Byte.class, (Schema<?>)ByteSchema.of());
        pulsarPrimitives.put(Byte.TYPE, (Schema<?>)ByteSchema.of());
        pulsarPrimitives.put(Short.class, (Schema<?>)ShortSchema.of());
        pulsarPrimitives.put(Short.TYPE, (Schema<?>)ShortSchema.of());
        pulsarPrimitives.put(Integer.class, (Schema<?>)IntSchema.of());
        pulsarPrimitives.put(Integer.TYPE, (Schema<?>)IntSchema.of());
        pulsarPrimitives.put(Long.class, (Schema<?>)LongSchema.of());
        pulsarPrimitives.put(Long.TYPE, (Schema<?>)LongSchema.of());
        pulsarPrimitives.put(String.class, Schema.STRING);
        pulsarPrimitives.put(Float.class, (Schema<?>)FloatSchema.of());
        pulsarPrimitives.put(Float.TYPE, (Schema<?>)FloatSchema.of());
        pulsarPrimitives.put(Double.class, (Schema<?>)DoubleSchema.of());
        pulsarPrimitives.put(Double.TYPE, (Schema<?>)DoubleSchema.of());
        pulsarPrimitives.put(Byte[].class, (Schema<?>)BytesSchema.of());
        pulsarPrimitives.put(Date.class, (Schema<?>)DateSchema.of());
        pulsarPrimitives.put(Time.class, (Schema<?>)TimeSchema.of());
        pulsarPrimitives.put(Timestamp.class, (Schema<?>)TimestampSchema.of());
        pulsarPrimitives.put(LocalDate.class, (Schema<?>)LocalDateSchema.of());
        pulsarPrimitives.put(LocalTime.class, (Schema<?>)LocalTimeSchema.of());
        pulsarPrimitives.put(LocalDateTime.class, (Schema<?>)LocalDateTimeSchema.of());
        pulsarPrimitives.put(Instant.class, (Schema<?>)InstantSchema.of());
    }
}

