/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.apache.flink.shaded.guava30.com.google.common.base.MoreObjects;
import org.apache.flink.shaded.guava30.com.google.common.collect.ComparisonChain;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.pulsar.client.api.Range;

public class TopicRange
implements Externalizable,
Comparable<TopicRange> {
    private String topic;
    private SerializableRange range;

    public TopicRange() {
        this(null, null);
    }

    public TopicRange(String topic) {
        this.topic = topic;
        this.range = SerializableRange.of(SerializableRange.fullRangeStart, SerializableRange.fullRangeEnd);
    }

    public TopicRange(String topic, Range range) {
        this.topic = topic;
        this.range = SerializableRange.of(range);
    }

    public TopicRange(String topic, int start, int end) {
        this.topic = topic;
        this.range = SerializableRange.of(start, end);
    }

    public String getTopic() {
        return this.topic;
    }

    public SerializableRange getRange() {
        return this.range;
    }

    public Range getPulsarRange() {
        return this.range.getPulsarRange();
    }

    public boolean isFullRange() {
        return this.range.getPulsarRange().getStart() == SerializableRange.fullRangeStart && this.range.getPulsarRange().getEnd() == SerializableRange.fullRangeEnd;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setRange(SerializableRange range) {
        this.range = range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicRange)) {
            return false;
        }
        TopicRange that = (TopicRange)o;
        return this.topic.equals(that.topic) && this.range.equals(that.range);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.range);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("key-range", (Object)this.range).toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.topic);
        out.writeObject(this.range);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topic = in.readUTF();
        this.range = (SerializableRange)in.readObject();
    }

    @Override
    public int compareTo(TopicRange o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.topic), (Comparable)((Object)o.topic)).compare((Comparable)this.range, (Comparable)o.range).result();
    }
}

